/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language.groovy;

import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.ClassName;
import io.spring.initializr.generator.language.CodeBlock;
import io.spring.initializr.generator.language.CompilationUnit;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.SourceCodeWriter;
import io.spring.initializr.generator.language.SourceStructure;
import io.spring.initializr.generator.language.groovy.GroovyCompilationUnit;
import io.spring.initializr.generator.language.groovy.GroovyExpression;
import io.spring.initializr.generator.language.groovy.GroovyExpressionStatement;
import io.spring.initializr.generator.language.groovy.GroovyFieldDeclaration;
import io.spring.initializr.generator.language.groovy.GroovyMethodDeclaration;
import io.spring.initializr.generator.language.groovy.GroovyMethodInvocation;
import io.spring.initializr.generator.language.groovy.GroovyReturnStatement;
import io.spring.initializr.generator.language.groovy.GroovySourceCode;
import io.spring.initializr.generator.language.groovy.GroovyStatement;
import io.spring.initializr.generator.language.groovy.GroovyTypeDeclaration;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GroovySourceCodeWriter
implements SourceCodeWriter<GroovySourceCode> {
    private static final CodeBlock.FormattingOptions FORMATTING_OPTIONS = new GroovyFormattingOptions();
    private static final Map<Predicate<Integer>, String> TYPE_MODIFIERS;
    private static final Map<Predicate<Integer>, String> FIELD_MODIFIERS;
    private static final Map<Predicate<Integer>, String> METHOD_MODIFIERS;
    private final IndentingWriterFactory indentingWriterFactory;

    public GroovySourceCodeWriter(IndentingWriterFactory indentingWriterFactory) {
        this.indentingWriterFactory = indentingWriterFactory;
    }

    @Override
    public void writeTo(SourceStructure structure, GroovySourceCode sourceCode) throws IOException {
        for (GroovyCompilationUnit compilationUnit : sourceCode.getCompilationUnits()) {
            this.writeTo(structure, compilationUnit);
        }
    }

    @Override
    private void writeTo(SourceStructure structure, GroovyCompilationUnit compilationUnit) throws IOException {
        Path output = structure.createSourceFile(compilationUnit.getPackageName(), compilationUnit.getName());
        try (IndentingWriter writer = this.indentingWriterFactory.createIndentingWriter("groovy", Files.newBufferedWriter(output, new OpenOption[0]));){
            writer.println("package " + compilationUnit.getPackageName());
            writer.println();
            Set<String> imports = this.determineImports(compilationUnit);
            if (!imports.isEmpty()) {
                for (String importedType : imports) {
                    writer.println("import " + importedType);
                }
                writer.println();
            }
            for (GroovyTypeDeclaration type : compilationUnit.getTypeDeclarations()) {
                List<GroovyMethodDeclaration> methodDeclarations;
                this.writeAnnotations(writer, type);
                this.writeModifiers(writer, TYPE_MODIFIERS, type.getModifiers());
                writer.print("class " + type.getName());
                if (type.getExtends() != null) {
                    writer.print(" extends " + this.getUnqualifiedName(type.getExtends()));
                }
                writer.println(" {");
                writer.println();
                List<GroovyFieldDeclaration> fieldDeclarations = type.getFieldDeclarations();
                if (!fieldDeclarations.isEmpty()) {
                    writer.indented(() -> {
                        for (GroovyFieldDeclaration fieldDeclaration : fieldDeclarations) {
                            this.writeFieldDeclaration(writer, fieldDeclaration);
                        }
                    });
                }
                if (!(methodDeclarations = type.getMethodDeclarations()).isEmpty()) {
                    writer.indented(() -> {
                        for (GroovyMethodDeclaration methodDeclaration : methodDeclarations) {
                            this.writeMethodDeclaration(writer, methodDeclaration);
                        }
                    });
                }
                writer.println("}");
            }
        }
    }

    private void writeAnnotations(IndentingWriter writer, Annotatable annotatable, Runnable separator) {
        annotatable.annotations().values().forEach(annotation -> {
            annotation.write(writer, FORMATTING_OPTIONS);
            separator.run();
        });
    }

    private void writeAnnotations(IndentingWriter writer, Annotatable annotatable) {
        this.writeAnnotations(writer, annotatable, writer::println);
    }

    private void writeFieldDeclaration(IndentingWriter writer, GroovyFieldDeclaration fieldDeclaration) {
        this.writeAnnotations(writer, fieldDeclaration);
        this.writeModifiers(writer, FIELD_MODIFIERS, fieldDeclaration.getModifiers());
        writer.print(this.getUnqualifiedName(fieldDeclaration.getReturnType()));
        writer.print(" ");
        writer.print(fieldDeclaration.getName());
        if (fieldDeclaration.isInitialized()) {
            writer.print(" = ");
            writer.print(String.valueOf(fieldDeclaration.getValue()));
        }
        writer.println();
        writer.println();
    }

    private void writeMethodDeclaration(IndentingWriter writer, GroovyMethodDeclaration methodDeclaration) {
        this.writeAnnotations(writer, methodDeclaration);
        this.writeModifiers(writer, METHOD_MODIFIERS, methodDeclaration.getModifiers());
        writer.print(this.getUnqualifiedName(methodDeclaration.getReturnType()) + " " + methodDeclaration.getName() + "(");
        this.writeParameters(writer, methodDeclaration.getParameters());
        writer.println(") {");
        writer.indented(() -> {
            methodDeclaration.getCode().write(writer, FORMATTING_OPTIONS);
            this.writeStatements(writer, methodDeclaration);
        });
        writer.println("}");
        writer.println();
    }

    private void writeParameters(IndentingWriter writer, List<Parameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Iterator<Parameter> it = parameters.iterator();
        while (it.hasNext()) {
            Parameter parameter = it.next();
            this.writeAnnotations(writer, parameter, () -> writer.print(" "));
            writer.print(this.getUnqualifiedName(parameter.getType()) + " " + parameter.getName());
            if (!it.hasNext()) continue;
            writer.print(", ");
        }
    }

    private void writeStatements(IndentingWriter writer, GroovyMethodDeclaration methodDeclaration) {
        List<GroovyStatement> statements = methodDeclaration.getStatements();
        for (GroovyStatement statement : statements) {
            if (statement instanceof GroovyExpressionStatement) {
                this.writeExpression(writer, ((GroovyExpressionStatement)statement).getExpression());
            } else if (statement instanceof GroovyReturnStatement) {
                this.writeExpression(writer, ((GroovyReturnStatement)statement).getExpression());
            }
            writer.println();
        }
    }

    private void writeModifiers(IndentingWriter writer, Map<Predicate<Integer>, String> availableModifiers, int declaredModifiers) {
        String modifiers = availableModifiers.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(declaredModifiers)).map(Map.Entry::getValue).collect(Collectors.joining(" "));
        if (!modifiers.isEmpty()) {
            writer.print(modifiers);
            writer.print(" ");
        }
    }

    private void writeExpression(IndentingWriter writer, GroovyExpression expression) {
        if (expression instanceof GroovyMethodInvocation) {
            this.writeMethodInvocation(writer, (GroovyMethodInvocation)expression);
        }
    }

    private void writeMethodInvocation(IndentingWriter writer, GroovyMethodInvocation methodInvocation) {
        writer.print(this.getUnqualifiedName(methodInvocation.getTarget()) + "." + methodInvocation.getName() + "(" + String.join((CharSequence)", ", methodInvocation.getArguments()) + ")");
    }

    private Set<String> determineImports(GroovyCompilationUnit compilationUnit) {
        ArrayList<String> imports = new ArrayList<String>();
        for (GroovyTypeDeclaration typeDeclaration : compilationUnit.getTypeDeclarations()) {
            imports.add(typeDeclaration.getExtends());
            imports.addAll(this.appendImports(typeDeclaration.annotations().values(), Annotation::getImports));
            for (GroovyFieldDeclaration fieldDeclaration : typeDeclaration.getFieldDeclarations()) {
                imports.add(fieldDeclaration.getReturnType());
                imports.addAll(this.appendImports(fieldDeclaration.annotations().values(), Annotation::getImports));
            }
            for (GroovyMethodDeclaration methodDeclaration : typeDeclaration.getMethodDeclarations()) {
                imports.add(methodDeclaration.getReturnType());
                imports.addAll(this.appendImports(methodDeclaration.annotations().values(), Annotation::getImports));
                for (Parameter parameter : methodDeclaration.getParameters()) {
                    imports.add(parameter.getType());
                    imports.addAll(this.appendImports(parameter.annotations().values(), Annotation::getImports));
                }
                imports.addAll(methodDeclaration.getCode().getImports());
                this.determineImportsFromStatements(imports, methodDeclaration);
            }
        }
        return imports.stream().filter(candidate -> this.isImportCandidate(compilationUnit, (String)candidate)).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void determineImportsFromStatements(List<String> imports, GroovyMethodDeclaration methodDeclaration) {
        imports.addAll(this.appendImports(methodDeclaration.getStatements().stream().filter(GroovyExpressionStatement.class::isInstance).map(GroovyExpressionStatement.class::cast).map(GroovyExpressionStatement::getExpression).filter(GroovyMethodInvocation.class::isInstance).map(GroovyMethodInvocation.class::cast), (T methodInvocation) -> Collections.singleton(methodInvocation.getTarget())));
    }

    private <T> List<String> appendImports(List<T> candidates, Function<T, Collection<String>> mapping) {
        return this.appendImports(candidates.stream(), mapping);
    }

    private <T> List<String> appendImports(Stream<T> candidates, Function<T, Collection<String>> mapping) {
        return candidates.map(mapping).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String getUnqualifiedName(String name) {
        if (!name.contains(".")) {
            return name;
        }
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private boolean isImportCandidate(CompilationUnit<?> compilationUnit, String name) {
        if (name == null || !name.contains(".")) {
            return false;
        }
        String packageName = name.substring(0, name.lastIndexOf(46));
        return !"java.lang".equals(packageName) && !compilationUnit.getPackageName().equals(packageName);
    }

    static {
        LinkedHashMap<Predicate<Integer>, String> typeModifiers = new LinkedHashMap<Predicate<Integer>, String>();
        typeModifiers.put(Modifier::isProtected, "protected");
        typeModifiers.put(Modifier::isPrivate, "private");
        typeModifiers.put(Modifier::isAbstract, "abstract");
        typeModifiers.put(Modifier::isStatic, "static");
        typeModifiers.put(Modifier::isFinal, "final");
        typeModifiers.put(Modifier::isStrict, "strictfp");
        TYPE_MODIFIERS = typeModifiers;
        LinkedHashMap<Predicate<Integer>, String> fieldModifiers = new LinkedHashMap<Predicate<Integer>, String>();
        fieldModifiers.put(Modifier::isPublic, "public");
        fieldModifiers.put(Modifier::isProtected, "protected");
        fieldModifiers.put(Modifier::isPrivate, "private");
        fieldModifiers.put(Modifier::isStatic, "static");
        fieldModifiers.put(Modifier::isFinal, "final");
        fieldModifiers.put(Modifier::isTransient, "transient");
        fieldModifiers.put(Modifier::isVolatile, "volatile");
        FIELD_MODIFIERS = fieldModifiers;
        LinkedHashMap<Predicate<Integer>, String> methodModifiers = new LinkedHashMap<Predicate<Integer>, String>(typeModifiers);
        methodModifiers.put(Modifier::isSynchronized, "synchronized");
        methodModifiers.put(Modifier::isNative, "native");
        METHOD_MODIFIERS = methodModifiers;
    }

    static class GroovyFormattingOptions
    implements CodeBlock.FormattingOptions {
        GroovyFormattingOptions() {
        }

        @Override
        public String statementSeparator() {
            return "";
        }

        @Override
        public CodeBlock arrayOf(CodeBlock ... values) {
            return CodeBlock.of("[ $L ]", CodeBlock.join(Arrays.asList(values), ", "));
        }

        @Override
        public CodeBlock classReference(ClassName className) {
            return CodeBlock.of("$T", className);
        }
    }
}

