/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language.java;

import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.AnnotationContainer;
import io.spring.initializr.generator.language.CodeBlock;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.java.JavaStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class JavaMethodDeclaration
implements Annotatable {
    private final AnnotationContainer annotations = new AnnotationContainer();
    private final String name;
    private final String returnType;
    private final int modifiers;
    private final List<Parameter> parameters;
    private final CodeBlock code;
    private final List<JavaStatement> statements;

    private JavaMethodDeclaration(Builder builder, CodeBlock code) {
        this.name = builder.name;
        this.returnType = builder.returnType;
        this.modifiers = builder.modifiers;
        this.parameters = List.copyOf(builder.parameters);
        this.code = code;
        this.statements = Collections.emptyList();
    }

    private JavaMethodDeclaration(String name, String returnType, int modifiers, List<Parameter> parameters, List<JavaStatement> statements) {
        this.name = name;
        this.returnType = returnType;
        this.modifiers = modifiers;
        this.parameters = parameters;
        this.code = CodeBlock.of("", new Object[0]);
        this.statements = statements;
    }

    public static Builder method(String name) {
        return new Builder(name);
    }

    String getName() {
        return this.name;
    }

    String getReturnType() {
        return this.returnType;
    }

    List<Parameter> getParameters() {
        return this.parameters;
    }

    int getModifiers() {
        return this.modifiers;
    }

    CodeBlock getCode() {
        return this.code;
    }

    @Deprecated(since="0.20.0", forRemoval=true)
    public List<JavaStatement> getStatements() {
        return this.statements;
    }

    @Override
    public AnnotationContainer annotations() {
        return this.annotations;
    }

    public static final class Builder {
        private final String name;
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private String returnType = "void";
        private int modifiers;

        private Builder(String name) {
            this.name = name;
        }

        public Builder modifiers(int modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public Builder returning(String returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder parameters(Parameter ... parameters) {
            this.parameters = Arrays.asList(parameters);
            return this;
        }

        public JavaMethodDeclaration body(CodeBlock code) {
            return new JavaMethodDeclaration(this, code);
        }

        @Deprecated(since="0.20.0", forRemoval=true)
        public JavaMethodDeclaration body(JavaStatement ... statements) {
            return new JavaMethodDeclaration(this.name, this.returnType, this.modifiers, this.parameters, Arrays.asList(statements));
        }
    }
}

