/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language.kotlin;

import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.AnnotationContainer;
import io.spring.initializr.generator.language.CodeBlock;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.kotlin.KotlinModifier;
import io.spring.initializr.generator.language.kotlin.KotlinStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class KotlinFunctionDeclaration
implements Annotatable {
    private final AnnotationContainer annotations = new AnnotationContainer();
    private final String name;
    private final String returnType;
    private final List<KotlinModifier> modifiers;
    private final List<Parameter> parameters;
    private final CodeBlock code;
    private final List<KotlinStatement> statements;

    private KotlinFunctionDeclaration(Builder builder, CodeBlock code) {
        this.name = builder.name;
        this.returnType = builder.returnType;
        this.modifiers = builder.modifiers;
        this.parameters = List.copyOf(builder.parameters);
        this.code = code;
        this.statements = Collections.emptyList();
    }

    private KotlinFunctionDeclaration(Builder builder, List<KotlinStatement> statements) {
        this.name = builder.name;
        this.returnType = builder.returnType;
        this.modifiers = builder.modifiers;
        this.parameters = List.copyOf(builder.parameters);
        this.code = CodeBlock.of("", new Object[0]);
        this.statements = List.copyOf(statements);
    }

    public static Builder function(String name) {
        return new Builder(name);
    }

    String getName() {
        return this.name;
    }

    String getReturnType() {
        return this.returnType;
    }

    List<Parameter> getParameters() {
        return this.parameters;
    }

    List<KotlinModifier> getModifiers() {
        return this.modifiers;
    }

    CodeBlock getCode() {
        return this.code;
    }

    @Deprecated(since="0.20.0", forRemoval=true)
    public List<KotlinStatement> getStatements() {
        return this.statements;
    }

    @Override
    public AnnotationContainer annotations() {
        return this.annotations;
    }

    public static final class Builder {
        private final String name;
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private List<KotlinModifier> modifiers = new ArrayList<KotlinModifier>();
        private String returnType;

        private Builder(String name) {
            this.name = name;
        }

        public Builder modifiers(KotlinModifier ... modifiers) {
            this.modifiers = Arrays.asList(modifiers);
            return this;
        }

        public Builder returning(String returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder parameters(Parameter ... parameters) {
            this.parameters = Arrays.asList(parameters);
            return this;
        }

        public KotlinFunctionDeclaration body(CodeBlock code) {
            return new KotlinFunctionDeclaration(this, code);
        }

        @Deprecated(since="0.20.0", forRemoval=true)
        public KotlinFunctionDeclaration body(KotlinStatement ... statements) {
            return new KotlinFunctionDeclaration(this, Arrays.asList(statements));
        }
    }
}

