/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class GradleConfiguration {
    private final String name;
    private final Set<String> extendsFrom;

    protected GradleConfiguration(Builder builder) {
        this.name = builder.name;
        this.extendsFrom = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.extendsFrom));
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getExtendsFrom() {
        return this.extendsFrom;
    }

    public static class Builder {
        private final String name;
        private final Set<String> extendsFrom = new LinkedHashSet<String>();

        protected Builder(String name) {
            this.name = name;
        }

        public Builder extendsFrom(String configurationName) {
            this.extendsFrom.add(configurationName);
            return this;
        }

        public GradleConfiguration build() {
            return new GradleConfiguration(this);
        }
    }
}

