/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class BuildItemContainer<I, V> {
    private final Map<I, V> items;
    private final Function<I, V> itemResolver;

    protected BuildItemContainer(Map<I, V> items, Function<I, V> itemResolver) {
        this.items = items;
        this.itemResolver = itemResolver;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean has(I id) {
        return this.items.containsKey(id);
    }

    public Stream<I> ids() {
        return this.items.keySet().stream();
    }

    public Stream<V> items() {
        return this.items.values().stream();
    }

    public V get(I id) {
        return this.items.get(id);
    }

    public void add(I id) {
        V item = this.itemResolver.apply(id);
        if (item == null) {
            throw new IllegalArgumentException("No such value with id '" + String.valueOf(id) + "'");
        }
        this.add(id, item);
    }

    public void add(I id, V item) {
        this.items.put(id, item);
    }

    public boolean remove(I id) {
        return this.items.remove(id) != null;
    }
}

