/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.Dependency;
import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuildSettings;
import io.spring.initializr.generator.io.IndentingWriter;

public abstract class GradleSettingsWriter {
    public final void writeTo(IndentingWriter writer, GradleBuild build) {
        this.writePluginManagement(writer, build);
        writer.println("rootProject.name = " + this.wrapWithQuotes(build.getSettings().getArtifact()));
    }

    private void writePluginManagement(IndentingWriter writer, GradleBuild build) {
        if (build.pluginRepositories().isEmpty() && build.getSettings().getPluginMappings().isEmpty()) {
            return;
        }
        writer.println("pluginManagement {");
        writer.indented(() -> {
            this.writeRepositories(writer, build);
            this.writeResolutionStrategy(writer, build);
        });
        writer.println("}");
    }

    private void writeRepositories(IndentingWriter writer, GradleBuild build) {
        if (build.pluginRepositories().isEmpty()) {
            return;
        }
        writer.println("repositories {");
        writer.indented(() -> {
            build.pluginRepositories().items().map(this::repositoryAsString).forEach(writer::println);
            writer.println("gradlePluginPortal()");
        });
        writer.println("}");
    }

    private void writeResolutionStrategy(IndentingWriter writer, GradleBuild build) {
        if (build.getSettings().getPluginMappings().isEmpty()) {
            return;
        }
        writer.println("resolutionStrategy {");
        writer.indented(() -> {
            writer.println("eachPlugin {");
            writer.indented(() -> build.getSettings().getPluginMappings().forEach(pluginMapping -> this.writePluginMapping(writer, (GradleBuildSettings.PluginMapping)pluginMapping)));
            writer.println("}");
        });
        writer.println("}");
    }

    private void writePluginMapping(IndentingWriter writer, GradleBuildSettings.PluginMapping pluginMapping) {
        writer.println("if (requested.id.id == " + this.wrapWithQuotes(pluginMapping.getId()) + ") {");
        Dependency dependency = pluginMapping.getDependency();
        String module = String.format("%s:%s:%s", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion().getValue());
        writer.indented(() -> writer.println("useModule(" + this.wrapWithQuotes(module) + ")"));
        writer.println("}");
    }

    private String repositoryAsString(MavenRepository repository) {
        if (MavenRepository.MAVEN_CENTRAL.equals(repository)) {
            return "mavenCentral()";
        }
        return "maven { " + this.urlAssignment(repository.getUrl()) + " }";
    }

    protected abstract String wrapWithQuotes(String var1);

    protected abstract String urlAssignment(String var1);
}

