/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import io.spring.initializr.generator.buildsystem.BillOfMaterials;
import io.spring.initializr.generator.buildsystem.BomContainer;
import io.spring.initializr.generator.buildsystem.Dependency;
import io.spring.initializr.generator.buildsystem.DependencyComparator;
import io.spring.initializr.generator.buildsystem.DependencyContainer;
import io.spring.initializr.generator.buildsystem.DependencyScope;
import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.buildsystem.MavenRepositoryContainer;
import io.spring.initializr.generator.buildsystem.PropertyContainer;
import io.spring.initializr.generator.buildsystem.maven.MavenBuild;
import io.spring.initializr.generator.buildsystem.maven.MavenBuildSettings;
import io.spring.initializr.generator.buildsystem.maven.MavenDependency;
import io.spring.initializr.generator.buildsystem.maven.MavenDeveloper;
import io.spring.initializr.generator.buildsystem.maven.MavenDistributionManagement;
import io.spring.initializr.generator.buildsystem.maven.MavenExtension;
import io.spring.initializr.generator.buildsystem.maven.MavenLicense;
import io.spring.initializr.generator.buildsystem.maven.MavenParent;
import io.spring.initializr.generator.buildsystem.maven.MavenPlugin;
import io.spring.initializr.generator.buildsystem.maven.MavenPluginContainer;
import io.spring.initializr.generator.buildsystem.maven.MavenProfile;
import io.spring.initializr.generator.buildsystem.maven.MavenProfileActivation;
import io.spring.initializr.generator.buildsystem.maven.MavenProfileContainer;
import io.spring.initializr.generator.buildsystem.maven.MavenResource;
import io.spring.initializr.generator.buildsystem.maven.MavenResourceContainer;
import io.spring.initializr.generator.buildsystem.maven.MavenScm;
import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.version.VersionProperty;
import io.spring.initializr.generator.version.VersionReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MavenBuildWriter {
    public void writeTo(IndentingWriter writer, MavenBuild build) {
        MavenBuildSettings settings = build.getSettings();
        this.writeProject(writer, () -> {
            this.writeParent(writer, build);
            this.writeProjectCoordinates(writer, settings);
            this.writePackaging(writer, settings);
            this.writeProjectName(writer, settings);
            this.writeUrl(writer, settings);
            this.writeLicenses(writer, settings);
            this.writeDevelopers(writer, settings);
            this.writeScm(writer, settings);
            this.writeProperties(writer, build.properties());
            this.writeDependencies(writer, build.dependencies());
            this.writeDependencyManagement(writer, build.boms());
            this.writeBuild(writer, build);
            this.writeRepositories(writer, build.repositories(), build.pluginRepositories());
            this.writeDistributionManagement(writer, build.getDistributionManagement());
            this.writeProfiles(writer, build);
        });
    }

    protected Comparator<Dependency> getDependencyComparator() {
        return DependencyComparator.INSTANCE;
    }

    private void writeProject(IndentingWriter writer, Runnable whenWritten) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        writer.indented(() -> {
            writer.println("xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd\">");
            this.writeSingleElement(writer, "modelVersion", "4.0.0");
            whenWritten.run();
        });
        writer.println();
        writer.println("</project>");
    }

    private void writeParent(IndentingWriter writer, MavenBuild build) {
        MavenParent parent = build.getSettings().getParent();
        if (parent == null) {
            return;
        }
        writer.println("<parent>");
        writer.indented(() -> {
            this.writeSingleElement(writer, "groupId", parent.getGroupId());
            this.writeSingleElement(writer, "artifactId", parent.getArtifactId());
            this.writeSingleElement(writer, "version", parent.getVersion());
            String relativePath = parent.getRelativePath();
            if (relativePath != null) {
                if (StringUtils.hasText((String)relativePath)) {
                    this.writeSingleElement(writer, "relativePath", relativePath);
                } else {
                    writer.println("<relativePath/> <!-- lookup parent from repository -->");
                }
            }
        });
        writer.println("</parent>");
    }

    private void writeProjectCoordinates(IndentingWriter writer, MavenBuildSettings settings) {
        this.writeSingleElement(writer, "groupId", settings.getGroup());
        this.writeSingleElement(writer, "artifactId", settings.getArtifact());
        this.writeSingleElement(writer, "version", settings.getVersion());
    }

    private void writePackaging(IndentingWriter writer, MavenBuildSettings settings) {
        String packaging = settings.getPackaging();
        if (!"jar".equals(packaging)) {
            this.writeSingleElement(writer, "packaging", packaging);
        }
    }

    private void writeProjectName(IndentingWriter writer, MavenBuildSettings settings) {
        this.writeSingleElement(writer, "name", settings.getName());
        this.writeSingleElement(writer, "description", settings.getDescription());
    }

    private void writeUrl(IndentingWriter writer, MavenBuildSettings settings) {
        String url = settings.getUrl();
        if (url == null && settings.isAddOverrideIfEmpty()) {
            url = "";
        }
        this.writeSingleElement(writer, "url", url);
    }

    private void writeProperties(IndentingWriter writer, PropertyContainer properties) {
        if (properties.isEmpty()) {
            return;
        }
        this.writeElement(writer, "properties", () -> {
            properties.values().forEach(entry -> this.writeSingleElement(writer, (String)entry.getKey(), entry.getValue()));
            properties.versions(VersionProperty::toStandardFormat).forEach(entry -> this.writeSingleElement(writer, (String)entry.getKey(), entry.getValue()));
        });
    }

    private void writeLicense(IndentingWriter writer, MavenLicense license) {
        this.writeElement(writer, "license", () -> {
            this.writeSingleElement(writer, "name", license.getName());
            this.writeSingleElement(writer, "url", license.getUrl());
            if (license.getDistribution() != null) {
                this.writeSingleElement(writer, "distribution", license.getDistribution().name().toLowerCase(Locale.ENGLISH));
            }
            this.writeSingleElement(writer, "comments", license.getComments());
        });
    }

    private void writeDeveloper(IndentingWriter writer, MavenDeveloper developer) {
        this.writeElement(writer, "developer", () -> {
            this.writeSingleElement(writer, "id", developer.getId());
            this.writeSingleElement(writer, "name", developer.getName());
            this.writeSingleElement(writer, "email", developer.getEmail());
            this.writeSingleElement(writer, "url", developer.getUrl());
            this.writeSingleElement(writer, "organization", developer.getOrganization());
            this.writeSingleElement(writer, "organizationUrl", developer.getOrganizationUrl());
            List<String> roles = developer.getRoles();
            if (!roles.isEmpty()) {
                this.writeElement(writer, "roles", () -> roles.forEach(role -> this.writeSingleElement(writer, "role", role)));
            }
            this.writeSingleElement(writer, "timezone", developer.getTimezone());
            Map<String, String> properties = developer.getProperties();
            if (!properties.isEmpty()) {
                this.writeElement(writer, "properties", () -> properties.forEach((key, value) -> this.writeSingleElement(writer, (String)key, value)));
            }
        });
    }

    private void writeDevelopers(IndentingWriter writer, MavenBuildSettings settings) {
        List<MavenDeveloper> developers = settings.getDevelopers();
        if (CollectionUtils.isEmpty(developers)) {
            if (settings.isAddOverrideIfEmpty()) {
                this.writeElement(writer, "developers", () -> this.writeSingleElement(writer, "developer", ""));
            }
        } else {
            this.writeCollectionElement(writer, "developers", settings.getDevelopers(), this::writeDeveloper);
        }
    }

    private void writeLicenses(IndentingWriter writer, MavenBuildSettings settings) {
        List<MavenLicense> licenses = settings.getLicenses();
        if (CollectionUtils.isEmpty(licenses)) {
            if (settings.isAddOverrideIfEmpty()) {
                this.writeElement(writer, "licenses", () -> this.writeSingleElement(writer, "license", ""));
            }
        } else {
            this.writeCollectionElement(writer, "licenses", licenses, this::writeLicense);
        }
    }

    private void writeScm(IndentingWriter writer, MavenBuildSettings settings) {
        MavenScm scm = settings.getScm();
        if (scm.isEmpty()) {
            if (settings.isAddOverrideIfEmpty()) {
                this.writeElement(writer, "scm", () -> {
                    this.writeSingleElement(writer, "connection", "");
                    this.writeSingleElement(writer, "developerConnection", "");
                    this.writeSingleElement(writer, "tag", "");
                    this.writeSingleElement(writer, "url", "");
                });
            }
        } else {
            this.writeElement(writer, "scm", () -> {
                this.writeSingleElement(writer, "connection", scm.getConnection());
                this.writeSingleElement(writer, "developerConnection", scm.getDeveloperConnection());
                this.writeSingleElement(writer, "tag", scm.getTag());
                this.writeSingleElement(writer, "url", scm.getUrl());
            });
        }
    }

    private void writeDependencies(IndentingWriter writer, DependencyContainer dependencies) {
        if (dependencies.isEmpty()) {
            return;
        }
        this.writeElement(writer, "dependencies", () -> {
            Collection<Dependency> compiledDependencies = this.writeDependencies(writer, dependencies, scope -> scope == null || scope == DependencyScope.COMPILE);
            if (!compiledDependencies.isEmpty()) {
                writer.println();
            }
            this.writeDependencies(writer, dependencies, this.hasScope(DependencyScope.RUNTIME));
            this.writeDependencies(writer, dependencies, this.hasScope(DependencyScope.COMPILE_ONLY));
            this.writeDependencies(writer, dependencies, this.hasScope(DependencyScope.ANNOTATION_PROCESSOR));
            this.writeDependencies(writer, dependencies, this.hasScope(DependencyScope.PROVIDED_RUNTIME));
            this.writeDependencies(writer, dependencies, this.hasScope(DependencyScope.TEST_COMPILE, DependencyScope.TEST_RUNTIME));
        });
    }

    private Predicate<DependencyScope> hasScope(DependencyScope ... validScopes) {
        return scope -> Arrays.asList(validScopes).contains(scope);
    }

    private Collection<Dependency> writeDependencies(IndentingWriter writer, DependencyContainer dependencies, Predicate<DependencyScope> filter) {
        List<Dependency> candidates = dependencies.items().filter(dep -> filter.test(dep.getScope())).sorted(this.getDependencyComparator()).toList();
        this.writeCollection(writer, candidates, this::writeDependency);
        return candidates;
    }

    private void writeDependency(IndentingWriter writer, Dependency dependency) {
        this.writeElement(writer, "dependency", () -> {
            this.writeSingleElement(writer, "groupId", dependency.getGroupId());
            this.writeSingleElement(writer, "artifactId", dependency.getArtifactId());
            this.writeSingleElement(writer, "version", this.determineVersion(dependency.getVersion()));
            this.writeSingleElement(writer, "scope", this.scopeForType(dependency.getScope()));
            this.writeSingleElement(writer, "classifier", dependency.getClassifier());
            if (this.isOptional(dependency)) {
                this.writeSingleElement(writer, "optional", Boolean.toString(true));
            }
            this.writeSingleElement(writer, "type", dependency.getType());
            this.writeCollectionElement(writer, "exclusions", dependency.getExclusions(), this::writeDependencyExclusion);
        });
    }

    private void writeDependencyExclusion(IndentingWriter writer, Dependency.Exclusion exclusion) {
        this.writeElement(writer, "exclusion", () -> {
            this.writeSingleElement(writer, "groupId", exclusion.getGroupId());
            this.writeSingleElement(writer, "artifactId", exclusion.getArtifactId());
        });
    }

    private String scopeForType(DependencyScope type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DependencyScope.ANNOTATION_PROCESSOR, DependencyScope.COMPILE, DependencyScope.COMPILE_ONLY -> null;
            case DependencyScope.PROVIDED_RUNTIME -> "provided";
            case DependencyScope.RUNTIME -> "runtime";
            case DependencyScope.TEST_COMPILE, DependencyScope.TEST_RUNTIME -> "test";
        };
    }

    private boolean isOptional(Dependency dependency) {
        MavenDependency mavenDependency;
        if (dependency instanceof MavenDependency && (mavenDependency = (MavenDependency)dependency).isOptional()) {
            return true;
        }
        return dependency.getScope() == DependencyScope.ANNOTATION_PROCESSOR || dependency.getScope() == DependencyScope.COMPILE_ONLY;
    }

    private void writeDependencyManagement(IndentingWriter writer, BomContainer boms) {
        if (boms.isEmpty()) {
            return;
        }
        this.writeElement(writer, "dependencyManagement", () -> this.writeCollectionElement(writer, "dependencies", boms.items().sorted(Comparator.comparing(BillOfMaterials::getOrder)).collect(Collectors.toList()), this::writeBom));
    }

    private void writeBom(IndentingWriter writer, BillOfMaterials bom) {
        this.writeElement(writer, "dependency", () -> {
            this.writeSingleElement(writer, "groupId", bom.getGroupId());
            this.writeSingleElement(writer, "artifactId", bom.getArtifactId());
            this.writeSingleElement(writer, "version", this.determineVersion(bom.getVersion()));
            this.writeSingleElement(writer, "type", "pom");
            this.writeSingleElement(writer, "scope", "import");
        });
    }

    private String determineVersion(VersionReference versionReference) {
        if (versionReference == null) {
            return null;
        }
        return versionReference.isProperty() ? "${" + versionReference.getProperty().toStandardFormat() + "}" : versionReference.getValue();
    }

    private void writeBuild(IndentingWriter writer, MavenBuild build) {
        MavenBuildSettings settings = build.getSettings();
        if (settings.getDefaultGoal() == null && settings.getFinalName() == null && settings.getSourceDirectory() == null && settings.getTestSourceDirectory() == null && build.resources().isEmpty() && build.testResources().isEmpty() && build.pluginManagementPlugins().isEmpty() && build.plugins().isEmpty() && build.extensions().isEmpty()) {
            return;
        }
        writer.println();
        this.writeElement(writer, "build", () -> {
            this.writeSingleElement(writer, "defaultGoal", settings.getDefaultGoal());
            this.writeSingleElement(writer, "finalName", settings.getFinalName());
            this.writeSingleElement(writer, "sourceDirectory", settings.getSourceDirectory());
            this.writeSingleElement(writer, "testSourceDirectory", settings.getTestSourceDirectory());
            this.writeResources(writer, build.resources(), build.testResources());
            this.writePluginManagement(writer, build.pluginManagementPlugins());
            this.writeCollectionElement(writer, "plugins", build.plugins().values(), this::writePlugin);
            this.writeCollectionElement(writer, "extensions", build.extensions().values(), this::writeExtension);
        });
    }

    private void writeResources(IndentingWriter writer, MavenResourceContainer resources, MavenResourceContainer testResources) {
        this.writeCollectionElement(writer, "resources", resources.values(), this::writeResource);
        this.writeCollectionElement(writer, "testResources", testResources.values(), this::writeTestResource);
    }

    private void writeResource(IndentingWriter writer, MavenResource resource) {
        this.writeResource(writer, resource, "resource");
    }

    private void writeTestResource(IndentingWriter writer, MavenResource resource) {
        this.writeResource(writer, resource, "testResource");
    }

    private void writeResource(IndentingWriter writer, MavenResource resource, String resourceName) {
        this.writeElement(writer, resourceName, () -> {
            this.writeSingleElement(writer, "directory", resource.getDirectory());
            this.writeSingleElement(writer, "targetPath", resource.getTargetPath());
            if (resource.isFiltering()) {
                this.writeSingleElement(writer, "filtering", "true");
            }
            this.writeCollectionElement(writer, "includes", resource.getIncludes(), this::writeResourceInclude);
            this.writeCollectionElement(writer, "excludes", resource.getExcludes(), this::writeResourceExclude);
        });
    }

    private void writeResourceInclude(IndentingWriter writer, String include) {
        this.writeSingleElement(writer, "include", include);
    }

    private void writeResourceExclude(IndentingWriter writer, String exclude) {
        this.writeSingleElement(writer, "exclude", exclude);
    }

    private void writePluginManagement(IndentingWriter writer, MavenPluginContainer pluginManagementContainer) {
        if (!pluginManagementContainer.isEmpty()) {
            this.writeElement(writer, "pluginManagement", () -> this.writeCollectionElement(writer, "plugins", pluginManagementContainer.values(), this::writePlugin));
        }
    }

    private void writePlugin(IndentingWriter writer, MavenPlugin plugin) {
        this.writeElement(writer, "plugin", () -> {
            this.writeSingleElement(writer, "groupId", plugin.getGroupId());
            this.writeSingleElement(writer, "artifactId", plugin.getArtifactId());
            this.writeSingleElement(writer, "version", this.determineVersion(plugin.getVersionReference()));
            if (!plugin.isInherited()) {
                this.writeSingleElement(writer, "inherited", "false");
            }
            if (plugin.isExtensions()) {
                this.writeSingleElement(writer, "extensions", "true");
            }
            this.writePluginConfiguration(writer, plugin.getConfiguration());
            this.writeCollectionElement(writer, "executions", plugin.getExecutions(), this::writePluginExecution);
            this.writeCollectionElement(writer, "dependencies", plugin.getDependencies(), this::writePluginDependency);
        });
    }

    private void writePluginConfiguration(IndentingWriter writer, MavenPlugin.Configuration configuration) {
        if (configuration == null || configuration.getSettings().isEmpty()) {
            return;
        }
        this.writeCollectionElement(writer, "configuration", configuration.getSettings(), this::writeSetting);
    }

    private void writeSetting(IndentingWriter writer, MavenPlugin.Setting setting) {
        if (setting.getValue() instanceof String) {
            this.writeSingleElement(writer, setting.getName(), setting.getValue());
        } else if (setting.getValue() instanceof List) {
            this.writeCollectionElement(writer, setting.getName(), (List)setting.getValue(), this::writeSetting);
        }
    }

    private void writePluginExecution(IndentingWriter writer, MavenPlugin.Execution execution) {
        this.writeElement(writer, "execution", () -> {
            List<String> processingInstructions = execution.getProcessingInstructions();
            for (String instruction : processingInstructions) {
                this.writeProcessingInstruction(writer, instruction);
            }
            this.writeSingleElement(writer, "id", execution.getId());
            this.writeSingleElement(writer, "phase", execution.getPhase());
            List<String> goals = execution.getGoals();
            if (!goals.isEmpty()) {
                this.writeElement(writer, "goals", () -> goals.forEach(goal -> this.writeSingleElement(writer, "goal", goal)));
            }
            this.writePluginConfiguration(writer, execution.getConfiguration());
        });
    }

    private void writePluginDependency(IndentingWriter writer, MavenPlugin.Dependency dependency) {
        this.writeElement(writer, "dependency", () -> {
            this.writeSingleElement(writer, "groupId", dependency.getGroupId());
            this.writeSingleElement(writer, "artifactId", dependency.getArtifactId());
            this.writeSingleElement(writer, "version", this.determineVersion(dependency.getVersionReference()));
        });
    }

    private void writeRepositories(IndentingWriter writer, MavenRepositoryContainer buildRepositories, MavenRepositoryContainer buildPluginRepositories) {
        List<MavenRepository> repositories = this.filterRepositories(buildRepositories.items());
        List<MavenRepository> pluginRepositories = this.filterRepositories(buildPluginRepositories.items());
        if (repositories.isEmpty() && pluginRepositories.isEmpty()) {
            return;
        }
        this.writeCollectionElement(writer, "repositories", repositories, this::writeRepository);
        this.writeCollectionElement(writer, "pluginRepositories", pluginRepositories, this::writePluginRepository);
    }

    private List<MavenRepository> filterRepositories(Stream<MavenRepository> repositories) {
        return repositories.filter(repository -> !MavenRepository.MAVEN_CENTRAL.equals(repository)).toList();
    }

    private void writeRepository(IndentingWriter writer, MavenRepository repository) {
        this.writeRepository(writer, repository, "repository");
    }

    private void writePluginRepository(IndentingWriter writer, MavenRepository repository) {
        this.writeRepository(writer, repository, "pluginRepository");
    }

    private void writeRepository(IndentingWriter writer, MavenRepository repository, String childName) {
        this.writeElement(writer, childName, () -> {
            this.writeSingleElement(writer, "id", repository.getId());
            this.writeSingleElement(writer, "name", repository.getName());
            this.writeSingleElement(writer, "url", repository.getUrl());
            if (!repository.isReleasesEnabled()) {
                this.writeElement(writer, "releases", () -> this.writeSingleElement(writer, "enabled", Boolean.toString(false)));
            }
            if (!repository.isSnapshotsEnabled()) {
                this.writeElement(writer, "snapshots", () -> this.writeSingleElement(writer, "enabled", Boolean.toString(false)));
            }
        });
    }

    private void writeDistributionManagement(IndentingWriter writer, MavenDistributionManagement distributionManagement) {
        if (distributionManagement.isEmpty()) {
            return;
        }
        this.writeElement(writer, "distributionManagement", () -> {
            MavenDistributionManagement.Relocation relocation;
            this.writeSingleElement(writer, "downloadUrl", distributionManagement.getDownloadUrl());
            this.writeDeploymentRepository(writer, "repository", distributionManagement.getRepository());
            this.writeDeploymentRepository(writer, "snapshotRepository", distributionManagement.getSnapshotRepository());
            MavenDistributionManagement.Site site = distributionManagement.getSite();
            if (!site.isEmpty()) {
                this.writeElement(writer, "site", () -> {
                    this.writeSingleElement(writer, "id", site.getId());
                    this.writeSingleElement(writer, "name", site.getName());
                    this.writeSingleElement(writer, "url", site.getUrl());
                });
            }
            if (!(relocation = distributionManagement.getRelocation()).isEmpty()) {
                this.writeElement(writer, "relocation", () -> {
                    this.writeSingleElement(writer, "groupId", relocation.getGroupId());
                    this.writeSingleElement(writer, "artifactId", relocation.getArtifactId());
                    this.writeSingleElement(writer, "version", relocation.getVersion());
                    this.writeSingleElement(writer, "message", relocation.getMessage());
                });
            }
        });
    }

    private void writeDeploymentRepository(IndentingWriter writer, String name, MavenDistributionManagement.DeploymentRepository repository) {
        if (!repository.isEmpty()) {
            this.writeElement(writer, name, () -> {
                this.writeSingleElement(writer, "id", repository.getId());
                this.writeSingleElement(writer, "name", repository.getName());
                this.writeSingleElement(writer, "url", repository.getUrl());
                this.writeSingleElement(writer, "layout", repository.getLayout());
                if (repository.getUniqueVersion() != null) {
                    this.writeSingleElement(writer, "uniqueVersion", Boolean.toString(repository.getUniqueVersion()));
                }
            });
        }
    }

    private void writeExtension(IndentingWriter writer, MavenExtension extension) {
        this.writeElement(writer, "extension", () -> {
            this.writeSingleElement(writer, "groupId", extension.getGroupId());
            this.writeSingleElement(writer, "artifactId", extension.getArtifactId());
            this.writeSingleElement(writer, "version", this.determineVersion(extension.getVersionReference()));
        });
    }

    private void writeProfiles(IndentingWriter writer, MavenBuild build) {
        MavenProfileContainer profiles = build.profiles();
        if (profiles.isEmpty()) {
            return;
        }
        writer.println();
        this.writeElement(writer, "profiles", () -> profiles.values().forEach(profile -> this.writeProfile(writer, (MavenProfile)profile)));
    }

    private void writeProfile(IndentingWriter writer, MavenProfile profile) {
        this.writeElement(writer, "profile", () -> {
            this.writeSingleElement(writer, "id", profile.getId());
            this.writeProfileActivation(writer, profile.getActivation());
            this.writeProperties(writer, profile.properties());
            this.writeDependencies(writer, profile.dependencies());
            this.writeDependencyManagement(writer, profile.boms());
            this.writeProfileBuild(writer, profile);
            this.writeRepositories(writer, profile.repositories(), profile.pluginRepositories());
            this.writeDistributionManagement(writer, profile.getDistributionManagement());
        });
    }

    private void writeProfileActivation(IndentingWriter writer, MavenProfileActivation activation) {
        if (activation.isEmpty()) {
            return;
        }
        this.writeElement(writer, "activation", () -> {
            this.writeSingleElement(writer, "activeByDefault", activation.getActiveByDefault());
            this.writeSingleElement(writer, "jdk", activation.getJdk());
            this.ifNotNull(activation.getOs(), os -> this.writeElement(writer, "os", () -> {
                this.writeSingleElement(writer, "name", os.getName());
                this.writeSingleElement(writer, "arch", os.getArch());
                this.writeSingleElement(writer, "family", os.getFamily());
                this.writeSingleElement(writer, "version", os.getVersion());
            }));
            this.ifNotNull(activation.getProperty(), property -> this.writeElement(writer, "property", () -> {
                this.writeSingleElement(writer, "name", property.getName());
                this.writeSingleElement(writer, "value", property.getValue());
            }));
            this.ifNotNull(activation.getFile(), file -> this.writeElement(writer, "file", () -> {
                this.writeSingleElement(writer, "exists", file.getExists());
                this.writeSingleElement(writer, "missing", file.getMissing());
            }));
        });
    }

    private void writeProfileBuild(IndentingWriter writer, MavenProfile profile) {
        MavenProfile.Settings settings = profile.getSettings();
        if (settings.getDefaultGoal() == null && settings.getFinalName() == null && profile.resources().isEmpty() && profile.testResources().isEmpty() && profile.pluginManagementPlugins().isEmpty() && profile.plugins().isEmpty()) {
            return;
        }
        this.writeElement(writer, "build", () -> {
            this.writeSingleElement(writer, "defaultGoal", settings.getDefaultGoal());
            this.writeSingleElement(writer, "finalName", settings.getFinalName());
            this.writeResources(writer, profile.resources(), profile.testResources());
            this.writePluginManagement(writer, profile.pluginManagementPlugins());
            this.writeCollectionElement(writer, "plugins", profile.plugins().values(), this::writePlugin);
        });
    }

    private void writeSingleElement(IndentingWriter writer, String name, Object value) {
        if (value != null) {
            CharSequence text;
            CharSequence charSequence = text = value instanceof CharSequence ? (CharSequence)value : value.toString();
            if (!StringUtils.hasLength((CharSequence)text)) {
                writer.println(String.format("<%s/>", name));
            } else {
                writer.print(String.format("<%s>", name));
                writer.print(this.encodeText(text));
                writer.println(String.format("</%s>", name));
            }
        }
    }

    private void writeProcessingInstruction(IndentingWriter writer, String content) {
        writer.println(String.format("<?%s?>", content));
    }

    private void writeElement(IndentingWriter writer, String name, Runnable withContent) {
        writer.println(String.format("<%s>", name));
        writer.indented(withContent);
        writer.println(String.format("</%s>", name));
    }

    private <T> void writeCollectionElement(IndentingWriter writer, String name, Stream<T> items, BiConsumer<IndentingWriter, T> itemWriter) {
        this.writeCollectionElement(writer, name, items.toList(), itemWriter);
    }

    private <T> void writeCollectionElement(IndentingWriter writer, String name, Collection<T> items, BiConsumer<IndentingWriter, T> itemWriter) {
        if (!ObjectUtils.isEmpty(items)) {
            this.writeElement(writer, name, () -> this.writeCollection(writer, items, itemWriter));
        }
    }

    private <T> void writeCollection(IndentingWriter writer, Collection<T> collection, BiConsumer<IndentingWriter, T> itemWriter) {
        if (!collection.isEmpty()) {
            collection.forEach(item -> itemWriter.accept(writer, item));
        }
    }

    private <T> void ifNotNull(T value, Consumer<T> elementWriter) {
        if (value != null) {
            elementWriter.accept(value);
        }
    }

    private String encodeText(CharSequence text) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char character = text.charAt(i);
            switch (character) {
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(character);
                }
            }
        }
        return sb.toString();
    }
}

