/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import io.spring.initializr.generator.version.VersionReference;

public class MavenExtension {
    private final String groupId;
    private final String artifactId;
    private final VersionReference version;

    protected MavenExtension(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Deprecated(forRemoval=true)
    public String getVersion() {
        return this.version != null ? this.version.getValue() : null;
    }

    public VersionReference getVersionReference() {
        return this.version;
    }

    public static class Builder {
        private final String groupId;
        private final String artifactId;
        private VersionReference version;

        protected Builder(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public Builder version(String version) {
            if (version == null) {
                return this.versionReference(null);
            }
            return this.versionReference(VersionReference.ofValue(version));
        }

        public Builder versionReference(VersionReference version) {
            this.version = version;
            return this;
        }

        public MavenExtension build() {
            return new MavenExtension(this);
        }
    }
}

