/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MavenResource {
    private final String directory;
    private final String targetPath;
    private final boolean filtering;
    private final List<String> includes;
    private final List<String> excludes;

    public MavenResource(Builder builder) {
        this.directory = builder.directory;
        this.targetPath = builder.targetPath;
        this.filtering = builder.filtering;
        this.includes = builder.includes;
        this.excludes = builder.excludes;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public boolean isFiltering() {
        return this.filtering;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public static class Builder {
        private final String directory;
        private String targetPath;
        private boolean filtering;
        private List<String> includes = new ArrayList<String>();
        private List<String> excludes = new ArrayList<String>();

        public Builder(String directory) {
            this.directory = directory;
        }

        public Builder targetPath(String targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        public Builder filtering(Boolean filtering) {
            this.filtering = filtering;
            return this;
        }

        public Builder includes(String ... includes) {
            this.includes = Arrays.asList(includes);
            return this;
        }

        public Builder excludes(String ... excludes) {
            this.excludes = Arrays.asList(excludes);
            return this;
        }

        public MavenResource build() {
            return new MavenResource(this);
        }
    }
}

