/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.container.docker.compose;

import io.spring.initializr.generator.container.docker.compose.ComposeFile;
import io.spring.initializr.generator.container.docker.compose.ComposeService;
import io.spring.initializr.generator.io.IndentingWriter;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

public class ComposeFileWriter {
    public void writeTo(IndentingWriter writer, ComposeFile compose) {
        writer.println("services:");
        compose.services().values().sorted(Comparator.comparing(ComposeService::getName)).forEach(service -> this.writeService(writer, (ComposeService)service));
    }

    private void writeService(IndentingWriter writer, ComposeService service) {
        writer.indented(() -> {
            writer.println(service.getName() + ":");
            writer.indented(() -> {
                writer.println("image: '%s:%s'".formatted(service.getImage(), service.getImageTag()));
                this.writerServiceEnvironment(writer, service.getEnvironment());
                this.writerServiceLabels(writer, service.getLabels());
                this.writerServicePorts(writer, service.getPorts());
                this.writeServiceCommand(writer, service.getCommand());
            });
        });
    }

    private void writerServiceEnvironment(IndentingWriter writer, Map<String, String> environment) {
        if (environment.isEmpty()) {
            return;
        }
        writer.println("environment:");
        writer.indented(() -> {
            for (Map.Entry env : environment.entrySet()) {
                writer.println("- '%s=%s'".formatted(env.getKey(), env.getValue()));
            }
        });
    }

    private void writerServicePorts(IndentingWriter writer, Set<Integer> ports) {
        if (ports.isEmpty()) {
            return;
        }
        writer.println("ports:");
        writer.indented(() -> {
            for (Integer port : ports) {
                writer.println("- '%d'".formatted(port));
            }
        });
    }

    private void writeServiceCommand(IndentingWriter writer, String command) {
        if (!StringUtils.hasText((String)command)) {
            return;
        }
        writer.println("command: '%s'".formatted(command));
    }

    private void writerServiceLabels(IndentingWriter writer, Map<String, String> labels) {
        if (labels.isEmpty()) {
            return;
        }
        writer.println("labels:");
        writer.indented(() -> {
            for (Map.Entry label : labels.entrySet()) {
                writer.println("- \"%s=%s\"".formatted(label.getKey(), label.getValue()));
            }
        });
    }
}

