/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language;

import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.language.ClassName;
import io.spring.initializr.generator.language.CodeBlock;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.ClassUtils;

public final class Annotation {
    private final ClassName className;
    private final List<Attribute> attributes;
    private final List<String> imports;

    private Annotation(Builder builder) {
        this.className = builder.className;
        this.attributes = List.copyOf(builder.attributes.values());
        this.imports = List.copyOf(builder.imports);
    }

    public ClassName getClassName() {
        return this.className;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public static Builder of(ClassName className) {
        return new Builder(className);
    }

    public void write(IndentingWriter writer, CodeBlock.FormattingOptions options) {
        new AnnotationWriter(writer, options).write(this);
    }

    public static final class Builder {
        private final ClassName className;
        private final Set<String> imports = new HashSet<String>();
        private final Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();

        Builder(ClassName name) {
            this.className = name;
            if (!name.getPackageName().isEmpty()) {
                this.imports.add(name.getName());
            }
        }

        Builder(Builder copy) {
            this.className = copy.className;
            this.imports.addAll(copy.imports);
            this.attributes.putAll(copy.attributes);
        }

        public Builder set(String name, Object ... values) {
            AttributeType type = this.determineAttributeType(values);
            this.attributes.put(name, new Attribute(name, type, values));
            return this;
        }

        public Builder add(String name, Object ... values) {
            AttributeType type = this.determineAttributeType(values);
            this.attributes.merge(name, new Attribute(name, type, values), this::append);
            return this;
        }

        public Builder from(Annotation annotation) {
            if (!this.className.equals(annotation.className)) {
                throw new IllegalArgumentException();
            }
            this.imports.clear();
            this.imports.addAll(annotation.imports);
            this.attributes.clear();
            annotation.attributes.forEach(attribute -> this.attributes.put(attribute.getName(), (Attribute)attribute));
            return this;
        }

        private Attribute append(Attribute existing, Attribute additional) {
            AttributeType typeToUse = AttributeType.getMostSpecificType(existing.type, additional.type);
            return new Attribute(existing.name, typeToUse, Stream.concat(existing.values.stream(), additional.values.stream()).toArray());
        }

        private AttributeType determineAttributeType(Object ... values) {
            AttributeType attributeType = AttributeType.of(values);
            Arrays.stream(values).map(attributeType::getImports).forEach(this.imports::addAll);
            return attributeType;
        }

        public Annotation build() {
            return new Annotation(this);
        }
    }

    private static class AnnotationWriter {
        private final IndentingWriter writer;
        private final CodeBlock.FormattingOptions formattingOptions;

        AnnotationWriter(IndentingWriter writer, CodeBlock.FormattingOptions formattingOptions) {
            this.writer = writer;
            this.formattingOptions = formattingOptions;
        }

        void write(Annotation annotation) {
            this.generateAnnotationCode(annotation).write(this.writer, this.formattingOptions);
        }

        private CodeBlock generateAnnotationCode(Annotation annotation) {
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("@$T", annotation.className);
            if (annotation.attributes.size() == 1 && annotation.attributes.get(0).getName().equals("value")) {
                code.add("($L)", this.generateAttributeValuesCode(annotation.attributes.get(0)));
            } else if (!annotation.attributes.isEmpty()) {
                CodeBlock attributes = annotation.attributes.stream().map(this::generateAttributeCode).collect(CodeBlock.joining(", "));
                code.add("($L)", attributes);
            }
            return code.build();
        }

        private CodeBlock generateAttributeCode(Attribute attribute) {
            return CodeBlock.of("$L = $L", attribute.name, this.generateAttributeValuesCode(attribute));
        }

        private CodeBlock generateAttributeValuesCode(Attribute attribute) {
            CodeBlock[] values = (CodeBlock[])attribute.values.stream().map(value -> this.generateValueCode(attribute.type, value)).toArray(CodeBlock[]::new);
            return values.length == 1 ? values[0] : this.formattingOptions.arrayOf(values);
        }

        private CodeBlock generateValueCode(AttributeType attributeType, Object value) {
            Class valueType = ClassUtils.resolvePrimitiveIfNecessary(value.getClass());
            if (value instanceof CodeBlock) {
                CodeBlock codeBlock = (CodeBlock)value;
                return codeBlock;
            }
            return switch (attributeType) {
                default -> throw new IncompatibleClassChangeError();
                case AttributeType.PRIMITIVE -> {
                    if (valueType == Character.class) {
                        yield CodeBlock.of("'$L'", value);
                    }
                    yield CodeBlock.of("$L", value);
                }
                case AttributeType.STRING -> CodeBlock.of("$S", value);
                case AttributeType.CLASS -> {
                    ClassName v1;
                    if (value instanceof Class) {
                        Class clazz = (Class)value;
                        v1 = ClassName.of(clazz);
                    } else {
                        v1 = (ClassName)value;
                    }
                    ClassName className = v1;
                    yield this.formattingOptions.classReference(className);
                }
                case AttributeType.ENUM -> {
                    Enum enumValue = (Enum)value;
                    yield CodeBlock.of("$T.$L", enumValue.getClass(), enumValue.name());
                }
                case AttributeType.ANNOTATION -> this.generateAnnotationCode((Annotation)value);
                case AttributeType.CODE -> (CodeBlock)value;
            };
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AttributeType {
        PRIMITIVE,
        STRING,
        CLASS{

            @Override
            protected Collection<String> getImports(Object value) {
                if (value instanceof Class) {
                    Class type = (Class)value;
                    return List.of(type.getName());
                }
                if (value instanceof ClassName) {
                    ClassName name = (ClassName)value;
                    return List.of(name.getName());
                }
                return super.getImports(value);
            }
        }
        ,
        ENUM{

            @Override
            protected Collection<String> getImports(Object value) {
                if (value instanceof Enum) {
                    Enum enumeration = (Enum)value;
                    return List.of(enumeration.getClass().getName());
                }
                return super.getImports(value);
            }
        }
        ,
        ANNOTATION{

            @Override
            protected Collection<String> getImports(Object value) {
                if (value instanceof Annotation) {
                    Annotation annotation = (Annotation)value;
                    return annotation.getImports();
                }
                return super.getImports(value);
            }
        }
        ,
        CODE{

            @Override
            protected boolean isCompatible(AttributeType attributeType) {
                return true;
            }
        };


        protected boolean isCompatible(AttributeType attributeType) {
            return this.equals((Object)attributeType) || attributeType == CODE;
        }

        protected Collection<String> getImports(Object value) {
            if (value instanceof CodeBlock) {
                CodeBlock codeBlock = (CodeBlock)value;
                return codeBlock.getImports();
            }
            return Collections.emptyList();
        }

        static AttributeType getMostSpecificType(AttributeType left, AttributeType right) {
            if (!left.isCompatible(right)) {
                throw new IllegalArgumentException("Incompatible type. '%s' is not compatible with '%s'".formatted(new Object[]{left, right}));
            }
            return left == CODE ? right : left;
        }

        static AttributeType of(Object ... values) {
            List<AttributeType> types = Arrays.stream(values).map(AttributeType::determineAttributeType).filter(type -> type != CODE).distinct().toList();
            if (types.size() > 1) {
                throw new IllegalArgumentException("Parameter value must not have mixed types, got [" + types.stream().map(Enum::name).collect(Collectors.joining(", ")) + "]");
            }
            return types.size() == 1 ? types.get(0) : CODE;
        }

        private static AttributeType determineAttributeType(Object value) {
            if (ClassUtils.isPrimitiveOrWrapper(value.getClass())) {
                return PRIMITIVE;
            }
            if (value instanceof CharSequence) {
                return STRING;
            }
            if (value instanceof Class || value instanceof ClassName) {
                return CLASS;
            }
            if (value instanceof Enum) {
                return ENUM;
            }
            if (value instanceof Annotation) {
                return ANNOTATION;
            }
            if (value instanceof CodeBlock) {
                return CODE;
            }
            throw new IllegalArgumentException("Incompatible type. Found: '%s', required: primitive, String, Class, an Enum, an Annotation, or a CodeBlock".formatted(value.getClass().getName()));
        }
    }

    public static final class Attribute {
        private final String name;
        private final AttributeType type;
        private final List<Object> values;

        private Attribute(String name, AttributeType type, Object ... values) {
            this.name = name;
            this.type = type;
            this.values = Arrays.asList(values);
        }

        public String getName() {
            return this.name;
        }

        public AttributeType getType() {
            return this.type;
        }

        public List<Object> getValues() {
            return this.values;
        }
    }
}

