/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language;

import io.spring.initializr.generator.language.LanguageFactory;
import java.util.Objects;
import org.springframework.core.io.support.SpringFactoriesLoader;

public interface Language {
    public static final String DEFAULT_JVM_VERSION = "1.8";

    public String id();

    public String jvmVersion();

    public String sourceFileExtension();

    public boolean supportsEscapingKeywordsInPackage();

    public boolean isKeyword(String var1);

    public static Language forId(String id, String jvmVersion) {
        return SpringFactoriesLoader.loadFactories(LanguageFactory.class, (ClassLoader)LanguageFactory.class.getClassLoader()).stream().map(factory -> factory.createLanguage(id, jvmVersion)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unrecognized language id '" + id + "'"));
    }
}

