/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language.java;

import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.CodeBlock;
import io.spring.initializr.generator.language.CompilationUnit;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.SourceCodeWriter;
import io.spring.initializr.generator.language.SourceStructure;
import io.spring.initializr.generator.language.java.JavaCompilationUnit;
import io.spring.initializr.generator.language.java.JavaFieldDeclaration;
import io.spring.initializr.generator.language.java.JavaMethodDeclaration;
import io.spring.initializr.generator.language.java.JavaSourceCode;
import io.spring.initializr.generator.language.java.JavaTypeDeclaration;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;

public class JavaSourceCodeWriter
implements SourceCodeWriter<JavaSourceCode> {
    private static final Map<Predicate<Integer>, String> TYPE_MODIFIERS;
    private static final Map<Predicate<Integer>, String> FIELD_MODIFIERS;
    private static final Map<Predicate<Integer>, String> METHOD_MODIFIERS;
    private final IndentingWriterFactory indentingWriterFactory;

    public JavaSourceCodeWriter(IndentingWriterFactory indentingWriterFactory) {
        this.indentingWriterFactory = indentingWriterFactory;
    }

    @Override
    public void writeTo(SourceStructure structure, JavaSourceCode sourceCode) throws IOException {
        for (JavaCompilationUnit compilationUnit : sourceCode.getCompilationUnits()) {
            this.writeTo(structure, compilationUnit);
        }
    }

    @Override
    private void writeTo(SourceStructure structure, JavaCompilationUnit compilationUnit) throws IOException {
        Path output = structure.createSourceFile(compilationUnit.getPackageName(), compilationUnit.getName());
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        try (IndentingWriter writer = this.indentingWriterFactory.createIndentingWriter("java", Files.newBufferedWriter(output, new OpenOption[0]));){
            writer.println("package " + compilationUnit.getPackageName() + ";");
            writer.println();
            Set<String> imports = this.determineImports(compilationUnit);
            if (!imports.isEmpty()) {
                for (String importedType : imports) {
                    writer.println("import " + importedType + ";");
                }
                writer.println();
            }
            for (JavaTypeDeclaration type : compilationUnit.getTypeDeclarations()) {
                List<JavaMethodDeclaration> methodDeclarations;
                this.writeAnnotations(writer, type, writer::println);
                this.writeModifiers(writer, TYPE_MODIFIERS, type.getModifiers());
                writer.print("class " + type.getName());
                if (type.getExtends() != null) {
                    writer.print(" extends " + this.getUnqualifiedName(type.getExtends()));
                }
                if (!CollectionUtils.isEmpty(type.getImplements())) {
                    this.writeImplements(type, writer);
                }
                writer.println(" {");
                writer.println();
                List<JavaFieldDeclaration> fieldDeclarations = type.getFieldDeclarations();
                if (!fieldDeclarations.isEmpty()) {
                    writer.indented(() -> {
                        for (JavaFieldDeclaration fieldDeclaration : fieldDeclarations) {
                            this.writeFieldDeclaration(writer, fieldDeclaration);
                        }
                    });
                }
                if (!(methodDeclarations = type.getMethodDeclarations()).isEmpty()) {
                    writer.indented(() -> {
                        for (JavaMethodDeclaration methodDeclaration : methodDeclarations) {
                            this.writeMethodDeclaration(writer, methodDeclaration);
                        }
                    });
                }
                writer.println("}");
            }
        }
    }

    private void writeImplements(JavaTypeDeclaration type, IndentingWriter writer) {
        writer.print(" implements ");
        Iterator<String> iterator = type.getImplements().iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            writer.print(this.getUnqualifiedName(name));
            if (!iterator.hasNext()) continue;
            writer.print(", ");
        }
    }

    private void writeAnnotations(IndentingWriter writer, Annotatable annotatable, Runnable separator) {
        annotatable.annotations().values().forEach(annotation -> {
            annotation.write(writer, CodeBlock.JAVA_FORMATTING_OPTIONS);
            separator.run();
        });
    }

    private void writeAnnotations(IndentingWriter writer, Annotatable annotatable) {
        this.writeAnnotations(writer, annotatable, writer::println);
    }

    private void writeFieldDeclaration(IndentingWriter writer, JavaFieldDeclaration fieldDeclaration) {
        this.writeAnnotations(writer, fieldDeclaration);
        this.writeModifiers(writer, FIELD_MODIFIERS, fieldDeclaration.getModifiers());
        writer.print(this.getUnqualifiedName(fieldDeclaration.getReturnType()));
        writer.print(" ");
        writer.print(fieldDeclaration.getName());
        if (fieldDeclaration.isInitialized()) {
            writer.print(" = ");
            writer.print(String.valueOf(fieldDeclaration.getValue()));
        }
        writer.println(";");
        writer.println();
    }

    private void writeMethodDeclaration(IndentingWriter writer, JavaMethodDeclaration methodDeclaration) {
        this.writeAnnotations(writer, methodDeclaration);
        this.writeModifiers(writer, METHOD_MODIFIERS, methodDeclaration.getModifiers());
        writer.print(this.getUnqualifiedName(methodDeclaration.getReturnType()) + " " + methodDeclaration.getName() + "(");
        this.writeParameters(writer, methodDeclaration.getParameters());
        writer.println(") {");
        writer.indented(() -> methodDeclaration.getCode().write(writer, CodeBlock.JAVA_FORMATTING_OPTIONS));
        writer.println("}");
        writer.println();
    }

    private void writeParameters(IndentingWriter writer, List<Parameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Iterator<Parameter> it = parameters.iterator();
        while (it.hasNext()) {
            Parameter parameter = it.next();
            this.writeAnnotations(writer, parameter, () -> writer.print(" "));
            writer.print(this.getUnqualifiedName(parameter.getType()) + " " + parameter.getName());
            if (!it.hasNext()) continue;
            writer.print(", ");
        }
    }

    private void writeModifiers(IndentingWriter writer, Map<Predicate<Integer>, String> availableModifiers, int declaredModifiers) {
        String modifiers = availableModifiers.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(declaredModifiers)).map(Map.Entry::getValue).collect(Collectors.joining(" "));
        if (!modifiers.isEmpty()) {
            writer.print(modifiers);
            writer.print(" ");
        }
    }

    private Set<String> determineImports(JavaCompilationUnit compilationUnit) {
        ArrayList<String> imports = new ArrayList<String>();
        for (JavaTypeDeclaration typeDeclaration : compilationUnit.getTypeDeclarations()) {
            imports.add(typeDeclaration.getExtends());
            imports.addAll(typeDeclaration.getImplements());
            imports.addAll(this.appendImports(typeDeclaration.annotations().values(), Annotation::getImports));
            for (JavaFieldDeclaration fieldDeclaration : typeDeclaration.getFieldDeclarations()) {
                imports.add(fieldDeclaration.getReturnType());
                imports.addAll(this.appendImports(fieldDeclaration.annotations().values(), Annotation::getImports));
            }
            for (JavaMethodDeclaration methodDeclaration : typeDeclaration.getMethodDeclarations()) {
                imports.add(methodDeclaration.getReturnType());
                imports.addAll(this.appendImports(methodDeclaration.annotations().values(), Annotation::getImports));
                for (Parameter parameter : methodDeclaration.getParameters()) {
                    imports.add(parameter.getType());
                    imports.addAll(this.appendImports(parameter.annotations().values(), Annotation::getImports));
                }
                imports.addAll(methodDeclaration.getCode().getImports());
            }
        }
        return imports.stream().filter(candidate -> this.isImportCandidate(compilationUnit, (String)candidate)).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private <T> List<String> appendImports(Stream<T> candidates, Function<T, Collection<String>> mapping) {
        return candidates.map(mapping).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String getUnqualifiedName(String name) {
        if (!name.contains(".")) {
            return name;
        }
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private boolean isImportCandidate(CompilationUnit<?> compilationUnit, String name) {
        if (name == null || !name.contains(".")) {
            return false;
        }
        String packageName = name.substring(0, name.lastIndexOf(46));
        return !"java.lang".equals(packageName) && !compilationUnit.getPackageName().equals(packageName);
    }

    static {
        LinkedHashMap<Predicate<Integer>, String> typeModifiers = new LinkedHashMap<Predicate<Integer>, String>();
        typeModifiers.put(Modifier::isPublic, "public");
        typeModifiers.put(Modifier::isProtected, "protected");
        typeModifiers.put(Modifier::isPrivate, "private");
        typeModifiers.put(Modifier::isAbstract, "abstract");
        typeModifiers.put(Modifier::isStatic, "static");
        typeModifiers.put(Modifier::isFinal, "final");
        typeModifiers.put(Modifier::isStrict, "strictfp");
        TYPE_MODIFIERS = typeModifiers;
        LinkedHashMap<Predicate<Integer>, String> fieldModifiers = new LinkedHashMap<Predicate<Integer>, String>();
        fieldModifiers.put(Modifier::isPublic, "public");
        fieldModifiers.put(Modifier::isProtected, "protected");
        fieldModifiers.put(Modifier::isPrivate, "private");
        fieldModifiers.put(Modifier::isStatic, "static");
        fieldModifiers.put(Modifier::isFinal, "final");
        fieldModifiers.put(Modifier::isTransient, "transient");
        fieldModifiers.put(Modifier::isVolatile, "volatile");
        FIELD_MODIFIERS = fieldModifiers;
        LinkedHashMap<Predicate<Integer>, String> methodModifiers = new LinkedHashMap<Predicate<Integer>, String>(typeModifiers);
        methodModifiers.put(Modifier::isSynchronized, "synchronized");
        methodModifiers.put(Modifier::isNative, "native");
        METHOD_MODIFIERS = methodModifiers;
    }
}

