/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.version;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.util.StringUtils;

public final class VersionProperty
implements Serializable,
Comparable<VersionProperty> {
    private static final long serialVersionUID = 1L;
    private static final List<Character> SUPPORTED_CHARS = Arrays.asList(Character.valueOf('.'), Character.valueOf('-'));
    private final String property;
    private final boolean internal;

    private VersionProperty(String property, boolean internal) {
        this.property = VersionProperty.validateFormat(property);
        this.internal = internal;
    }

    public static VersionProperty of(String property, boolean internal) {
        return new VersionProperty(property, internal);
    }

    public static VersionProperty of(String property) {
        return VersionProperty.of(property, true);
    }

    public boolean isInternal() {
        return this.internal;
    }

    public String toCamelCaseFormat() {
        String[] tokens = this.property.split("[-.]");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            String part = tokens[i];
            if (i > 0) {
                part = StringUtils.capitalize((String)part);
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public String toStandardFormat() {
        return this.property;
    }

    private static String validateFormat(String property) {
        for (char c : property.toCharArray()) {
            if (Character.isUpperCase(c)) {
                throw new IllegalArgumentException("Invalid property '" + property + "', must not contain upper case");
            }
            if (Character.isLetterOrDigit(c) || SUPPORTED_CHARS.contains(Character.valueOf(c))) continue;
            throw new IllegalArgumentException("Unsupported character '" + c + "' for '" + property + "'");
        }
        return property;
    }

    @Override
    public int compareTo(VersionProperty o) {
        return this.property.compareTo(o.property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionProperty that = (VersionProperty)o;
        return this.internal == that.internal && this.property.equals(that.property);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.internal);
    }

    public String toString() {
        return this.property;
    }
}

