/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.version;

import io.spring.initializr.generator.version.VersionProperty;
import java.util.Objects;

public final class VersionReference {
    private final VersionProperty property;
    private final String value;

    private VersionReference(VersionProperty property, String value) {
        this.property = property;
        this.value = value;
    }

    public static VersionReference ofProperty(VersionProperty property) {
        return new VersionReference(property, null);
    }

    public static VersionReference ofProperty(String internalProperty) {
        return VersionReference.ofProperty(VersionProperty.of(internalProperty));
    }

    public static VersionReference ofValue(String value) {
        return new VersionReference(null, value);
    }

    public boolean isProperty() {
        return this.property != null;
    }

    public VersionProperty getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionReference that = (VersionReference)o;
        return Objects.equals(this.property, that.property) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.value);
    }

    public String toString() {
        return this.property != null ? "${" + this.property.toStandardFormat() + "}" : this.value;
    }
}

