/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.spring.initializr.generator.version.InvalidVersionException;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionParser;
import io.spring.initializr.generator.version.VersionProperty;
import io.spring.initializr.generator.version.VersionRange;
import io.spring.initializr.metadata.InvalidInitializrMetadataException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class BillOfMaterials {
    private String groupId;
    private String artifactId;
    private String version;
    private VersionProperty versionProperty;
    private Integer order = Integer.MAX_VALUE;
    private List<String> additionalBoms = new ArrayList<String>();
    private List<String> repositories = new ArrayList<String>();
    private final List<Mapping> mappings = new ArrayList<Mapping>();

    public BillOfMaterials() {
    }

    private BillOfMaterials(String groupId, String artifactId) {
        this(groupId, artifactId, null);
    }

    private BillOfMaterials(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public VersionProperty getVersionProperty() {
        return this.versionProperty;
    }

    public void setVersionProperty(VersionProperty versionProperty) {
        this.versionProperty = versionProperty;
    }

    public void setVersionProperty(String versionPropertyName) {
        this.setVersionProperty(VersionProperty.of((String)versionPropertyName));
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public List<String> getAdditionalBoms() {
        return this.additionalBoms;
    }

    public void setAdditionalBoms(List<String> additionalBoms) {
        this.additionalBoms = additionalBoms;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<String> repositories) {
        this.repositories = repositories;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    public void validate() {
        if (this.version == null && this.mappings.isEmpty()) {
            throw new InvalidInitializrMetadataException("No version available for " + this);
        }
        this.updateCompatibilityRange(VersionParser.DEFAULT);
    }

    public void updateCompatibilityRange(VersionParser versionParser) {
        this.mappings.forEach(it -> {
            try {
                Assert.notNull((Object)((Mapping)it).compatibilityRange, (String)("Invalid mapping for " + this + ": compatibility range is mandatory"));
                ((Mapping)it).range = versionParser.parseRange(((Mapping)it).compatibilityRange);
            }
            catch (InvalidVersionException ex) {
                throw new InvalidInitializrMetadataException("Invalid compatibility range " + ((Mapping)it).compatibilityRange + " for " + this, ex);
            }
        });
    }

    public BillOfMaterials resolve(Version bootVersion) {
        if (this.mappings.isEmpty()) {
            return this;
        }
        for (Mapping mapping : this.mappings) {
            if (!mapping.range.match(bootVersion)) continue;
            BillOfMaterials resolvedBom = new BillOfMaterials(mapping.groupId != null ? mapping.groupId : this.groupId, mapping.artifactId != null ? mapping.artifactId : this.artifactId, mapping.version);
            resolvedBom.setVersionProperty(this.versionProperty);
            resolvedBom.setOrder(this.order);
            resolvedBom.repositories.addAll(!mapping.repositories.isEmpty() ? mapping.repositories : this.repositories);
            resolvedBom.additionalBoms.addAll(!mapping.additionalBoms.isEmpty() ? mapping.additionalBoms : this.additionalBoms);
            return resolvedBom;
        }
        throw new InvalidInitializrMetadataException("No suitable mapping was found for " + this + " and version " + bootVersion);
    }

    public String toString() {
        return "BillOfMaterials [" + (this.groupId != null ? "groupId=" + this.groupId + ", " : "") + (this.artifactId != null ? "artifactId=" + this.artifactId + ", " : "") + (this.version != null ? "version=" + this.version + ", " : "") + (this.versionProperty != null ? "versionProperty=" + this.versionProperty + ", " : "") + (this.order != null ? "order=" + this.order + ", " : "") + (this.additionalBoms != null ? "additionalBoms=" + this.additionalBoms + ", " : "") + (this.repositories != null ? "repositories=" + this.repositories : "") + "]";
    }

    public static BillOfMaterials create(String groupId, String artifactId) {
        return new BillOfMaterials(groupId, artifactId);
    }

    public static BillOfMaterials create(String groupId, String artifactId, String version) {
        return new BillOfMaterials(groupId, artifactId, version);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Mapping {
        private String compatibilityRange;
        private String groupId;
        private String artifactId;
        private String version;
        private List<String> repositories = new ArrayList<String>();
        private List<String> additionalBoms = new ArrayList<String>();
        @JsonIgnore
        private VersionRange range;

        public Mapping() {
        }

        private Mapping(String range, String version, String ... repositories) {
            this.compatibilityRange = range;
            this.version = version;
            this.repositories.addAll(Arrays.asList(repositories));
        }

        public String determineCompatibilityRangeRequirement() {
            return this.range.toString();
        }

        public static Mapping create(String range, String version) {
            return new Mapping(range, version, new String[0]);
        }

        public static Mapping create(String range, String version, String ... repositories) {
            return new Mapping(range, version, repositories);
        }

        public String getCompatibilityRange() {
            return this.compatibilityRange;
        }

        public void setCompatibilityRange(String compatibilityRange) {
            this.compatibilityRange = compatibilityRange;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public List<String> getRepositories() {
            return this.repositories;
        }

        public List<String> getAdditionalBoms() {
            return this.additionalBoms;
        }

        public VersionRange getRange() {
            return this.range;
        }

        public void setRepositories(List<String> repositories) {
            this.repositories = repositories;
        }

        public void setAdditionalBoms(List<String> additionalBoms) {
            this.additionalBoms = additionalBoms;
        }

        public void setRange(VersionRange range) {
            this.range = range;
        }

        public String toString() {
            return "Mapping [" + (this.compatibilityRange != null ? "compatibilityRange=" + this.compatibilityRange + ", " : "") + (this.groupId != null ? "groupId=" + this.groupId + ", " : "") + (this.artifactId != null ? "artifactId=" + this.artifactId + ", " : "") + (this.version != null ? "version=" + this.version + ", " : "") + (this.repositories != null ? "repositories=" + this.repositories + ", " : "") + (this.additionalBoms != null ? "additionalBoms=" + this.additionalBoms + ", " : "") + (this.range != null ? "range=" + this.range : "") + "]";
        }
    }
}

