/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.spring.initializr.generator.version.InvalidVersionException;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionParser;
import io.spring.initializr.generator.version.VersionRange;
import io.spring.initializr.metadata.Describable;
import io.spring.initializr.metadata.InvalidInitializrMetadataException;
import io.spring.initializr.metadata.Link;
import io.spring.initializr.metadata.MetadataElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Dependency
extends MetadataElement
implements Describable {
    public static final String SCOPE_COMPILE = "compile";
    public static final String SCOPE_COMPILE_ONLY = "compileOnly";
    public static final String SCOPE_ANNOTATION_PROCESSOR = "annotationProcessor";
    public static final String SCOPE_RUNTIME = "runtime";
    public static final String SCOPE_PROVIDED = "provided";
    public static final String SCOPE_TEST = "test";
    public static final List<String> SCOPE_ALL = Collections.unmodifiableList(Arrays.asList("compile", "runtime", "compileOnly", "annotationProcessor", "provided", "test"));
    private List<String> aliases = new ArrayList<String>();
    private List<String> facets = new ArrayList<String>();
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type;
    private List<Mapping> mappings = new ArrayList<Mapping>();
    private String scope = "compile";
    private String description;
    private String compatibilityRange;
    @JsonIgnore
    private String versionRequirement;
    @JsonIgnore
    private VersionRange range;
    private String bom;
    private String repository;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private int weight;
    private boolean starter = true;
    private List<String> keywords = new ArrayList<String>();
    private List<Link> links = new ArrayList<Link>();

    public Dependency() {
    }

    public Dependency(Dependency dependency) {
        super(dependency);
        this.aliases.addAll(dependency.aliases);
        this.facets.addAll(dependency.facets);
        this.groupId = dependency.groupId;
        this.artifactId = dependency.artifactId;
        this.version = dependency.version;
        this.classifier = dependency.classifier;
        this.type = dependency.type;
        this.mappings.addAll(dependency.mappings);
        this.scope = dependency.scope;
        this.description = dependency.description;
        this.compatibilityRange = dependency.compatibilityRange;
        this.versionRequirement = dependency.versionRequirement;
        this.range = dependency.range;
        this.bom = dependency.bom;
        this.repository = dependency.repository;
        this.weight = dependency.weight;
        this.starter = dependency.starter;
        this.keywords.addAll(dependency.keywords);
        this.links.addAll(dependency.links);
    }

    public void setScope(String scope) {
        if (!SCOPE_ALL.contains(scope)) {
            throw new InvalidInitializrMetadataException("Invalid scope " + scope + " must be one of " + SCOPE_ALL);
        }
        this.scope = scope;
    }

    public void setCompatibilityRange(String compatibilityRange) {
        this.compatibilityRange = StringUtils.hasText((String)compatibilityRange) ? compatibilityRange.trim() : null;
    }

    private boolean hasCoordinates() {
        return this.groupId != null && this.artifactId != null;
    }

    public void resolve() {
        if (this.getId() == null) {
            if (!this.hasCoordinates()) {
                throw new InvalidInitializrMetadataException("Invalid dependency, should have at least an id or a groupId/artifactId pair.");
            }
            this.generateId();
        } else if (!this.hasCoordinates()) {
            StringTokenizer st = new StringTokenizer(this.getId(), ":");
            if (st.countTokens() == 1) {
                this.asSpringBootStarter(this.getId());
            } else if (st.countTokens() == 2 || st.countTokens() == 3) {
                this.groupId = st.nextToken();
                this.artifactId = st.nextToken();
                if (st.hasMoreTokens()) {
                    this.version = st.nextToken();
                }
            } else {
                throw new InvalidInitializrMetadataException("Invalid dependency, id should have the form groupId:artifactId[:version] but got " + this.getId());
            }
        }
        this.links.forEach(Link::resolve);
        this.updateCompatibilityRange(VersionParser.DEFAULT);
    }

    private Dependency asSpringBootStarter(String name) {
        this.groupId = "org.springframework.boot";
        String string = this.artifactId = StringUtils.hasText((String)name) ? "spring-boot-starter-" + name : "spring-boot-starter";
        if (StringUtils.hasText((String)name)) {
            this.setId(name);
        }
        return this;
    }

    public void updateCompatibilityRange(VersionParser versionParser) {
        if (this.compatibilityRange != null) {
            try {
                this.range = versionParser.parseRange(this.compatibilityRange);
                this.compatibilityRange = this.range.toRangeString();
                this.versionRequirement = this.range.toString();
            }
            catch (InvalidVersionException ex) {
                throw new InvalidInitializrMetadataException("Invalid compatibility range '" + this.compatibilityRange + " for dependency with id '" + this.getId() + "'", ex);
            }
        }
        this.mappings.forEach(it -> {
            try {
                Assert.notNull((Object)((Mapping)it).compatibilityRange, (String)("Invalid mapping for " + this + ": compatibility range is mandatory"));
                ((Mapping)it).range = versionParser.parseRange(((Mapping)it).compatibilityRange);
            }
            catch (InvalidVersionException ex) {
                throw new InvalidInitializrMetadataException("Invalid compatibility range " + ((Mapping)it).compatibilityRange + " for " + this, ex);
            }
        });
    }

    public Dependency resolve(Version bootVersion) {
        for (Mapping mapping : this.mappings) {
            if (!mapping.range.match(bootVersion)) continue;
            Dependency dependency = new Dependency(this);
            dependency.groupId = mapping.groupId != null ? mapping.groupId : this.groupId;
            dependency.artifactId = mapping.artifactId != null ? mapping.artifactId : this.artifactId;
            dependency.version = mapping.version != null ? mapping.version : this.version;
            dependency.starter = mapping.starter != null ? mapping.starter : this.starter;
            dependency.bom = mapping.bom != null ? mapping.bom : this.bom;
            dependency.repository = mapping.repository != null ? mapping.repository : this.repository;
            dependency.versionRequirement = mapping.range.toString();
            dependency.mappings = null;
            return dependency;
        }
        return this;
    }

    public boolean match(Version version) {
        if (this.range != null) {
            return this.range.match(version);
        }
        return true;
    }

    public String generateId() {
        if (this.groupId == null || this.artifactId == null) {
            throw new IllegalArgumentException("Could not generate id for " + this + ": at least groupId and artifactId must be set.");
        }
        this.setId(this.groupId + ":" + this.artifactId);
        return this.getId();
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public List<String> getFacets() {
        return this.facets;
    }

    public void setFacets(List<String> facets) {
        this.facets = facets;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<Mapping> mappings) {
        this.mappings = mappings;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersionRequirement() {
        return this.versionRequirement;
    }

    public void setVersionRequirement(String versionRequirement) {
        this.versionRequirement = versionRequirement;
    }

    public VersionRange getRange() {
        return this.range;
    }

    public void setRange(VersionRange range) {
        this.range = range;
    }

    public String getBom() {
        return this.bom;
    }

    public void setBom(String bom) {
        this.bom = bom;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean isStarter() {
        return this.starter;
    }

    public void setStarter(boolean starter) {
        this.starter = starter;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public String getScope() {
        return this.scope;
    }

    public String getCompatibilityRange() {
        return this.compatibilityRange;
    }

    public String toString() {
        return "Dependency{id='" + this.getId() + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + '}';
    }

    public static Dependency create(String groupId, String artifactId, String version, String scope) {
        Dependency dependency = Dependency.withId(null, groupId, artifactId, version);
        dependency.setScope(scope);
        return dependency;
    }

    public static Dependency createSpringBootStarter(String name) {
        return Dependency.createSpringBootStarter(name, null);
    }

    public static Dependency createSpringBootStarter(String name, String scope) {
        Dependency dependency = new Dependency();
        dependency.asSpringBootStarter(name);
        if (StringUtils.hasText((String)scope)) {
            dependency.setScope(scope);
        }
        return dependency;
    }

    public static Dependency withId(String id, String groupId, String artifactId, String version, String scope) {
        Dependency dependency = new Dependency();
        dependency.setId(id);
        dependency.groupId = groupId;
        dependency.artifactId = artifactId;
        dependency.version = version;
        dependency.scope = scope != null ? scope : SCOPE_COMPILE;
        return dependency;
    }

    public static Dependency withId(String id, String groupId, String artifactId, String version) {
        return Dependency.withId(id, groupId, artifactId, version, null);
    }

    public static Dependency withId(String id, String groupId, String artifactId) {
        return Dependency.withId(id, groupId, artifactId, null);
    }

    public static Dependency withId(String id, String scope) {
        Dependency dependency = Dependency.withId(id, null, null);
        dependency.setScope(scope);
        return dependency;
    }

    public static Dependency withId(String id) {
        return Dependency.withId(id, SCOPE_COMPILE);
    }

    public static class Mapping {
        private String compatibilityRange;
        private String groupId;
        private String artifactId;
        private String version;
        private Boolean starter;
        private String bom;
        private String repository;
        @JsonIgnore
        private VersionRange range;

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Boolean getStarter() {
            return this.starter;
        }

        public void setStarter(Boolean starter) {
            this.starter = starter;
        }

        public String getBom() {
            return this.bom;
        }

        public void setBom(String bom) {
            this.bom = bom;
        }

        public String getRepository() {
            return this.repository;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        public VersionRange getRange() {
            return this.range;
        }

        public String getCompatibilityRange() {
            return this.compatibilityRange;
        }

        public void setCompatibilityRange(String compatibilityRange) {
            this.compatibilityRange = compatibilityRange;
        }

        public static Mapping create(String range, String groupId, String artifactId, String version, Boolean starter, String bom, String repository) {
            Mapping mapping = new Mapping();
            mapping.compatibilityRange = range;
            mapping.groupId = groupId;
            mapping.artifactId = artifactId;
            mapping.version = version;
            mapping.starter = starter;
            mapping.bom = bom;
            mapping.repository = repository;
            return mapping;
        }
    }
}

