/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata.support;

import io.spring.initializr.generator.buildsystem.DependencyScope;
import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.version.VersionProperty;
import io.spring.initializr.generator.version.VersionReference;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.Repository;

public final class MetadataBuildItemMapper {
    private MetadataBuildItemMapper() {
    }

    public static io.spring.initializr.generator.buildsystem.Dependency toDependency(Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        VersionReference versionReference = dependency.getVersion() != null ? VersionReference.ofValue((String)dependency.getVersion()) : null;
        return io.spring.initializr.generator.buildsystem.Dependency.withCoordinates((String)dependency.getGroupId(), (String)dependency.getArtifactId()).version(versionReference).scope(MetadataBuildItemMapper.toDependencyScope(dependency.getScope())).classifier(dependency.getClassifier()).type(dependency.getType()).build();
    }

    private static DependencyScope toDependencyScope(String scope) {
        switch (scope) {
            case "annotationProcessor": {
                return DependencyScope.ANNOTATION_PROCESSOR;
            }
            case "compile": {
                return DependencyScope.COMPILE;
            }
            case "runtime": {
                return DependencyScope.RUNTIME;
            }
            case "compileOnly": {
                return DependencyScope.COMPILE_ONLY;
            }
            case "provided": {
                return DependencyScope.PROVIDED_RUNTIME;
            }
            case "test": {
                return DependencyScope.TEST_COMPILE;
            }
        }
        return null;
    }

    public static io.spring.initializr.generator.buildsystem.BillOfMaterials toBom(BillOfMaterials bom) {
        if (bom == null) {
            return null;
        }
        VersionReference version = bom.getVersionProperty() != null ? VersionReference.ofProperty((VersionProperty)bom.getVersionProperty()) : VersionReference.ofValue((String)bom.getVersion());
        return io.spring.initializr.generator.buildsystem.BillOfMaterials.withCoordinates((String)bom.getGroupId(), (String)bom.getArtifactId()).version(version).order(bom.getOrder().intValue()).build();
    }

    public static MavenRepository toRepository(String id, Repository repository) {
        if (repository == null) {
            return null;
        }
        return MavenRepository.withIdAndUrl((String)id, (String)repository.getUrl().toExternalForm()).name(repository.getName()).releasesEnabled(repository.isReleasesEnabled()).snapshotsEnabled(repository.isSnapshotsEnabled()).build();
    }
}

