/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.spring.initializr.metadata.ServiceCapabilityType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonIgnoreProperties(value={"default", "all"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class ServiceCapability<T>
implements Cloneable {
    private final String id;
    private final ServiceCapabilityType type;
    private String title;
    private String description;

    protected ServiceCapability(String id, ServiceCapabilityType type, String title, String description) {
        this.id = id;
        this.type = type;
        this.title = title;
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public ServiceCapabilityType getType() {
        return this.type;
    }

    public abstract T getContent();

    public abstract void merge(T var1);

    public void merge(ServiceCapability<T> other) {
        Assert.notNull(other, (String)"Other must not be null");
        Assert.isTrue((boolean)this.id.equals(other.id), (String)"Ids must be equals");
        Assert.isTrue((boolean)this.type.equals((Object)other.type), (String)"Types must be equals");
        if (StringUtils.hasText((String)other.title)) {
            this.title = other.title;
        }
        if (StringUtils.hasText((String)other.description)) {
            this.description = other.description;
        }
        this.merge(other.getContent());
    }
}

