/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.versionresolver;

import io.spring.initializr.versionresolver.DependencyManagementVersionResolver;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;

class MavenResolverDependencyManagementVersionResolver
implements DependencyManagementVersionResolver {
    private static final RemoteRepository mavenCentral = new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2").build();
    private static final RemoteRepository springMilestones = new RemoteRepository.Builder("spring-milestones", "default", "https://repo.spring.io/milestone").build();
    private static final RemoteRepository springSnapshots = new RemoteRepository.Builder("spring-snapshots", "default", "https://repo.spring.io/snapshot").build();
    private static final List<RemoteRepository> repositories = Arrays.asList(mavenCentral, springMilestones, springSnapshots);
    private final Object monitor = new Object();
    private final RepositorySystemSession repositorySystemSession;
    private final RepositorySystem repositorySystem;

    MavenResolverDependencyManagementVersionResolver(Path cacheLocation) {
        ServiceLocator serviceLocator = MavenResolverDependencyManagementVersionResolver.createServiceLocator();
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(false, false));
        LocalRepository localRepository = new LocalRepository(cacheLocation.toFile());
        this.repositorySystem = (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
        session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepository));
        session.setReadOnly();
        this.repositorySystemSession = session;
    }

    @Override
    public Map<String, String> resolve(String groupId, String artifactId, String version) {
        ArtifactDescriptorResult bom = this.resolveBom(groupId, artifactId, version);
        HashMap<String, String> managedVersions = new HashMap<String, String>();
        bom.getManagedDependencies().stream().map(Dependency::getArtifact).forEach(artifact -> managedVersions.putIfAbsent(artifact.getGroupId() + ":" + artifact.getArtifactId(), artifact.getVersion()));
        return managedVersions;
    }

    private ArtifactDescriptorResult resolveBom(String groupId, String artifactId, String version) {
        Object object = this.monitor;
        synchronized (object) {
            try {
                return this.repositorySystem.readArtifactDescriptor(this.repositorySystemSession, new ArtifactDescriptorRequest((Artifact)new DefaultArtifact(groupId, artifactId, "pom", version), repositories, null));
            }
            catch (ArtifactDescriptorException ex) {
                throw new IllegalStateException("Bom '" + groupId + ":" + artifactId + ":" + version + "' could not be resolved", ex);
            }
        }
    }

    private static ServiceLocator createServiceLocator() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositorySystem.class, DefaultRepositorySystem.class);
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return locator;
    }
}

