/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionRange;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.MetadataElement;
import io.spring.initializr.metadata.Type;
import io.spring.initializr.web.mapper.InitializrMetadataV2JsonMapper;
import io.spring.initializr.web.mapper.LinkMapper;
import java.util.List;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;

public class InitializrMetadataV21JsonMapper
extends InitializrMetadataV2JsonMapper {
    private final TemplateVariables dependenciesVariables = new TemplateVariables(new TemplateVariable[]{new TemplateVariable("bootVersion", TemplateVariable.VariableType.REQUEST_PARAM)});

    @Override
    protected ObjectNode links(ObjectNode parent, List<Type> types, String appUrl) {
        ObjectNode links = super.links(parent, types, appUrl);
        links.set("dependencies", (JsonNode)this.dependenciesLink(appUrl));
        parent.set("_links", (JsonNode)links);
        return links;
    }

    @Override
    protected ObjectNode mapDependency(Dependency dependency) {
        ObjectNode content = this.mapValue((MetadataElement)dependency);
        if (dependency.getRange() != null) {
            content.put("versionRange", this.formatVersionRange(dependency.getRange()));
        }
        if (dependency.getLinks() != null && !dependency.getLinks().isEmpty()) {
            content.set("_links", (JsonNode)LinkMapper.mapLinks(dependency.getLinks()));
        }
        return content;
    }

    protected String formatVersionRange(VersionRange versionRange) {
        return versionRange.format(Version.Format.V1).toRangeString();
    }

    private ObjectNode dependenciesLink(String appUrl) {
        String uri = appUrl != null ? appUrl + "/dependencies" : "/dependencies";
        UriTemplate uriTemplate = UriTemplate.of((String)uri, (TemplateVariables)this.dependenciesVariables);
        ObjectNode result = this.nodeFactory().objectNode();
        result.put("href", uriTemplate.toString());
        result.put("templated", true);
        return result;
    }
}

