/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.support;

import io.spring.initializr.generator.io.template.TemplateRenderer;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.MetadataElement;
import io.spring.initializr.metadata.Type;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.WordUtils;
import org.springframework.beans.BeanWrapperImpl;

public class CommandLineHelpGenerator {
    private static final String LOGO = "  .   ____          _            __ _ _\n /\\\\ / ___'_ __ _ _(_)_ __  __ _ \\ \\ \\ \\\n( ( )\\___ | '_ | '_| | '_ \\/ _` | \\ \\ \\ \\\n \\\\/  ___)| |_)| | | | | || (_| |  ) ) ) )\n  '  |____| .__|_| |_|_| |_\\__, | / / / /\n =========|_|==============|___/=/_/_/_/";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final TemplateRenderer template;
    private final int maxColumnWidth;

    public CommandLineHelpGenerator(TemplateRenderer template) {
        this(template, 60);
    }

    public CommandLineHelpGenerator(TemplateRenderer template, int maxColumnWidth) {
        this.template = template;
        this.maxColumnWidth = maxColumnWidth;
    }

    public String generateGenericCapabilities(InitializrMetadata metadata, String serviceUrl) throws IOException {
        Map<String, Object> model = this.initializeCommandLineModel(metadata, serviceUrl);
        model.put("hasExamples", false);
        return this.template.render("cli/cli-capabilities", model);
    }

    public String generateCurlCapabilities(InitializrMetadata metadata, String serviceUrl) throws IOException {
        Map<String, Object> model = this.initializeCommandLineModel(metadata, serviceUrl);
        model.put("examples", this.template.render("cli/curl-examples", model));
        model.put("hasExamples", true);
        return this.template.render("cli/cli-capabilities", model);
    }

    public String generateHttpieCapabilities(InitializrMetadata metadata, String serviceUrl) throws IOException {
        Map<String, Object> model = this.initializeCommandLineModel(metadata, serviceUrl);
        model.put("examples", this.template.render("cli/httpie-examples", model));
        model.put("hasExamples", true);
        return this.template.render("cli/cli-capabilities", model);
    }

    public String generateSpringBootCliCapabilities(InitializrMetadata metadata, String serviceUrl) throws IOException {
        Map<String, Object> model = this.initializeSpringBootCliModel(metadata, serviceUrl);
        model.put("hasExamples", false);
        return this.template.render("cli/boot-cli-capabilities", model);
    }

    protected Map<String, Object> initializeCommandLineModel(InitializrMetadata metadata, String serviceUrl) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        model.put("logo", LOGO);
        model.put("serviceUrl", serviceUrl);
        model.put("dependencies", this.generateDependencyTable(metadata));
        model.put("types", this.generateTypeTable(metadata, "Rel", false));
        Map defaults = metadata.defaults();
        defaults.put("applicationName", metadata.getConfiguration().generateApplicationName(metadata.getName().getContent()));
        defaults.put("baseDir", "no base dir");
        defaults.put("dependencies", "none");
        Map<String, Object> parametersDescription = this.buildParametersDescription(metadata);
        String[][] parameterTable = new String[defaults.size() + 1][];
        parameterTable[0] = new String[]{"Parameter", "Description", "Default value"};
        int i = 1;
        for (String id : defaults.keySet().stream().sorted().collect(Collectors.toList())) {
            String[] data = new String[]{id, (String)parametersDescription.get(id), (String)defaults.get(id)};
            parameterTable[i++] = data;
        }
        model.put("parameters", TableGenerator.generate(parameterTable, this.maxColumnWidth));
        return model;
    }

    protected Map<String, Object> initializeSpringBootCliModel(InitializrMetadata metadata, String serviceUrl) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        model.put("logo", LOGO);
        model.put("serviceUrl", serviceUrl);
        model.put("dependencies", this.generateDependencyTable(metadata));
        model.put("types", this.generateTypeTable(metadata, "Id", true));
        Map defaults = metadata.defaults();
        Map<String, Object> parametersDescription = this.buildParametersDescription(metadata);
        String[][] parameterTable = new String[defaults.size() + 1][];
        parameterTable[0] = new String[]{"Id", "Description", "Default value"};
        int i = 1;
        for (String id : defaults.keySet().stream().sorted().collect(Collectors.toList())) {
            String[] data = new String[]{id, (String)parametersDescription.get(id), (String)defaults.get(id)};
            parameterTable[i++] = data;
        }
        model.put("parameters", TableGenerator.generate(parameterTable, this.maxColumnWidth));
        return model;
    }

    protected String generateDependencyTable(InitializrMetadata metadata) {
        String[][] dependencyTable = new String[metadata.getDependencies().getAll().size() + 1][];
        dependencyTable[0] = new String[]{"Id", "Description", "Required version"};
        int i = 1;
        for (Dependency dep : metadata.getDependencies().getAll().stream().sorted(Comparator.comparing(MetadataElement::getId)).collect(Collectors.toList())) {
            String[] data = new String[]{dep.getId(), dep.getDescription() != null ? dep.getDescription() : dep.getName(), dep.getVersionRequirement()};
            dependencyTable[i++] = data;
        }
        return TableGenerator.generate(dependencyTable, this.maxColumnWidth);
    }

    protected String generateTypeTable(InitializrMetadata metadata, String linkHeader, boolean addTags) {
        String[][] typeTable = new String[metadata.getTypes().getContent().size() + 1][];
        typeTable[0] = addTags ? new String[]{linkHeader, "Description", "Tags"} : new String[]{linkHeader, "Description"};
        int i = 1;
        for (Type type : metadata.getTypes().getContent().stream().sorted(Comparator.comparing(MetadataElement::getId)).collect(Collectors.toList())) {
            String[] data = new String[typeTable[0].length];
            data[0] = type.isDefault() ? type.getId() + " *" : type.getId();
            String string = data[1] = type.getDescription() != null ? type.getDescription() : type.getName();
            if (addTags) {
                data[2] = CommandLineHelpGenerator.buildTagRepresentation(type);
            }
            typeTable[i++] = data;
        }
        return TableGenerator.generate(typeTable, this.maxColumnWidth);
    }

    protected Map<String, Object> buildParametersDescription(InitializrMetadata metadata) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)metadata);
        for (PropertyDescriptor descriptor : wrapper.getPropertyDescriptors()) {
            Object value = wrapper.getPropertyValue(descriptor.getName());
            BeanWrapperImpl nested = new BeanWrapperImpl(value);
            if (!nested.isReadableProperty("description") || !nested.isReadableProperty("id")) continue;
            result.put((String)nested.getPropertyValue("id"), nested.getPropertyValue("description"));
        }
        result.put("applicationName", "application name");
        result.put("baseDir", "base directory to create in the archive");
        return result;
    }

    private static String buildTagRepresentation(Type type) {
        if (type.getTags().isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", (CharSequence[])type.getTags().entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).toArray(String[]::new));
    }

    private static class HelpFormatter {
        private HelpFormatter() {
        }

        private static List<String[]> format(String[] content, int maxWidth) {
            List<String[]> columns = HelpFormatter.lineWrap(content, maxWidth);
            ArrayList<String[]> rows = new ArrayList<String[]>();
            for (int i = 0; i < HelpFormatter.largest(columns); ++i) {
                rows.add(HelpFormatter.computeRow(columns, i));
            }
            return rows;
        }

        private static String[] computeRow(List<String[]> columns, int index) {
            String[] line = new String[columns.size()];
            int position = 0;
            for (String[] column : columns) {
                line[position] = HelpFormatter.itemOrNull(column, index);
                ++position;
            }
            return line;
        }

        private static List<String[]> lineWrap(String[] content, int maxWidth) {
            ArrayList<String[]> lineWrapped = new ArrayList<String[]>();
            for (String column : content) {
                if (column == null) {
                    lineWrapped.add(new String[0]);
                    continue;
                }
                lineWrapped.add(WordUtils.wrap((String)column, (int)maxWidth).split(NEW_LINE));
            }
            return lineWrapped;
        }

        private static int largest(List<String[]> columns) {
            int max = 0;
            for (String[] column : columns) {
                if (max >= column.length) continue;
                max = column.length;
            }
            return max;
        }

        private static String itemOrNull(String[] column, int index) {
            return index >= column.length ? null : column[index];
        }
    }

    private static class TableGenerator {
        private TableGenerator() {
        }

        static String generate(String[][] content, int maxWidth) {
            int i;
            StringBuilder sb = new StringBuilder();
            boolean emptyRow = false;
            int[] columnsLength = TableGenerator.computeColumnsLength(content, maxWidth);
            LinkedList<List<String[]>> formattedContent = new LinkedList<List<String[]>>();
            for (i = 0; i < content.length; ++i) {
                List<String[]> rows = TableGenerator.computeRow(content, i, maxWidth);
                formattedContent.add(rows);
                if (rows.size() <= 1) continue;
                emptyRow = true;
            }
            TableGenerator.appendTableSeparation(sb, columnsLength);
            TableGenerator.appendRow(sb, formattedContent, columnsLength, 0);
            TableGenerator.appendTableSeparation(sb, columnsLength);
            for (i = 1; i < formattedContent.size(); ++i) {
                TableGenerator.appendRow(sb, formattedContent, columnsLength, i);
                if (!emptyRow || i >= content.length - 1) continue;
                TableGenerator.appendEmptyRow(sb, columnsLength);
            }
            TableGenerator.appendTableSeparation(sb, columnsLength);
            return sb.toString();
        }

        private static void appendRow(StringBuilder sb, List<List<String[]>> formattedContent, int[] columnsLength, int rowIndex) {
            List<String[]> rows = formattedContent.get(rowIndex);
            for (String[] row : rows) {
                for (int i = 0; i < row.length; ++i) {
                    sb.append("| ").append(TableGenerator.fill(row[i], columnsLength[i])).append(" ");
                }
                sb.append("|");
                sb.append(NEW_LINE);
            }
        }

        private static List<String[]> computeRow(String[][] content, int rowIndex, int maxWidth) {
            String[] line = content[rowIndex];
            return HelpFormatter.format(line, maxWidth);
        }

        private static void appendEmptyRow(StringBuilder sb, int[] columnsLength) {
            for (int columnLength : columnsLength) {
                sb.append("| ").append(TableGenerator.fill(null, columnLength)).append(" ");
            }
            sb.append("|");
            sb.append(NEW_LINE);
        }

        private static void appendTableSeparation(StringBuilder sb, int[] headersLength) {
            for (int headerLength : headersLength) {
                sb.append("+").append(TableGenerator.multiply("-", headerLength + 2));
            }
            sb.append("+");
            sb.append(NEW_LINE);
        }

        private static String fill(String data, int columnSize) {
            if (data == null) {
                return TableGenerator.multiply(" ", columnSize);
            }
            int i = columnSize - data.length();
            return data + TableGenerator.multiply(" ", i);
        }

        private static String multiply(String value, int size) {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                s.append(value);
            }
            return s.toString();
        }

        private static int[] computeColumnsLength(String[][] content, int maxWidth) {
            int count = content[0].length;
            int[] result = new int[count];
            for (int i = 0; i < count; ++i) {
                result[i] = TableGenerator.largest(content, i, maxWidth);
            }
            return result;
        }

        private static int largest(String[][] content, int column, int maxWidth) {
            int max = 0;
            for (String[] rows : content) {
                String s;
                if (rows == null || (s = rows[column]) == null || s.length() <= max) continue;
                max = s.length();
            }
            return Math.min(max, maxWidth);
        }
    }
}

