/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.DependencyMetadata;
import io.spring.initializr.metadata.Repository;
import io.spring.initializr.web.mapper.DependencyMetadataJsonMapper;
import java.util.Map;
import java.util.stream.Collectors;

public class DependencyMetadataV21JsonMapper
implements DependencyMetadataJsonMapper {
    private static final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;

    @Override
    public String write(DependencyMetadata metadata) {
        ObjectNode json = nodeFactory.objectNode();
        json.put("bootVersion", metadata.getBootVersion().toString());
        json.set("dependencies", DependencyMetadataV21JsonMapper.mapNode(metadata.getDependencies().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DependencyMetadataV21JsonMapper.mapDependency((Dependency)entry.getValue())))));
        json.set("repositories", DependencyMetadataV21JsonMapper.mapNode(metadata.getRepositories().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DependencyMetadataV21JsonMapper.mapRepository((Repository)entry.getValue())))));
        json.set("boms", DependencyMetadataV21JsonMapper.mapNode(metadata.getBoms().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DependencyMetadataV21JsonMapper.mapBom((BillOfMaterials)entry.getValue())))));
        return json.toString();
    }

    private static JsonNode mapDependency(Dependency dep) {
        ObjectNode node = nodeFactory.objectNode();
        node.put("groupId", dep.getGroupId());
        node.put("artifactId", dep.getArtifactId());
        if (dep.getVersion() != null) {
            node.put("version", dep.getVersion());
        }
        node.put("scope", dep.getScope());
        if (dep.getBom() != null) {
            node.put("bom", dep.getBom());
        }
        if (dep.getRepository() != null) {
            node.put("repository", dep.getRepository());
        }
        return node;
    }

    private static JsonNode mapRepository(Repository repo) {
        ObjectNode node = nodeFactory.objectNode();
        node.put("name", repo.getName()).put("url", repo.getUrl() != null ? repo.getUrl().toString() : null).put("snapshotEnabled", repo.isSnapshotsEnabled());
        return node;
    }

    private static JsonNode mapBom(BillOfMaterials bom) {
        ObjectNode node = nodeFactory.objectNode();
        node.put("groupId", bom.getGroupId());
        node.put("artifactId", bom.getArtifactId());
        if (bom.getVersion() != null) {
            node.put("version", bom.getVersion());
        }
        if (bom.getRepositories() != null) {
            ArrayNode array = nodeFactory.arrayNode();
            bom.getRepositories().forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
            node.set("repositories", (JsonNode)array);
        }
        return node;
    }

    private static JsonNode mapNode(Map<String, JsonNode> content) {
        ObjectNode node = nodeFactory.objectNode();
        content.forEach((arg_0, arg_1) -> ((ObjectNode)node).set(arg_0, arg_1));
        return node;
    }
}

