/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.project;

import io.spring.initializr.generator.buildsystem.BuildSystem;
import io.spring.initializr.generator.language.Language;
import io.spring.initializr.generator.packaging.Packaging;
import io.spring.initializr.generator.project.MutableProjectDescription;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.metadata.DefaultMetadataElement;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrConfiguration;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.Type;
import io.spring.initializr.metadata.support.MetadataBuildItemMapper;
import io.spring.initializr.web.project.InvalidProjectRequestException;
import io.spring.initializr.web.project.ProjectRequest;
import io.spring.initializr.web.project.ProjectRequestPlatformVersionTransformer;
import io.spring.initializr.web.project.ProjectRequestToDescriptionConverter;
import java.text.Normalizer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultProjectRequestToDescriptionConverter
implements ProjectRequestToDescriptionConverter<ProjectRequest> {
    private final ProjectRequestPlatformVersionTransformer platformVersionTransformer;

    public DefaultProjectRequestToDescriptionConverter() {
        this((version, metadata) -> version);
    }

    public DefaultProjectRequestToDescriptionConverter(ProjectRequestPlatformVersionTransformer platformVersionTransformer) {
        Assert.notNull((Object)platformVersionTransformer, (String)"PlatformVersionTransformer must not be null");
        this.platformVersionTransformer = platformVersionTransformer;
    }

    @Override
    public ProjectDescription convert(ProjectRequest request, InitializrMetadata metadata) {
        MutableProjectDescription description = new MutableProjectDescription();
        this.convert(request, description, metadata);
        return description;
    }

    public void convert(ProjectRequest request, MutableProjectDescription description, InitializrMetadata metadata) {
        this.validate(request, metadata);
        Version platformVersion = this.getPlatformVersion(request, metadata);
        List<Dependency> resolvedDependencies = this.getResolvedDependencies(request, platformVersion, metadata);
        this.validateDependencyRange(platformVersion, resolvedDependencies);
        description.setApplicationName(request.getApplicationName());
        description.setArtifactId(this.cleanInputValue(request.getArtifactId()));
        description.setBaseDirectory(request.getBaseDir());
        description.setBuildSystem(this.getBuildSystem(request, metadata));
        description.setDescription(request.getDescription());
        description.setGroupId(this.cleanInputValue(request.getGroupId()));
        description.setLanguage(Language.forId((String)request.getLanguage(), (String)request.getJavaVersion()));
        description.setName(this.cleanInputValue(request.getName()));
        description.setPackageName(this.cleanInputValue(request.getPackageName()));
        description.setPackaging(Packaging.forId((String)request.getPackaging()));
        description.setPlatformVersion(platformVersion);
        description.setVersion(request.getVersion());
        resolvedDependencies.forEach(dependency -> description.addDependency(dependency.getId(), MetadataBuildItemMapper.toDependency((Dependency)dependency)));
    }

    protected String cleanInputValue(String value) {
        return StringUtils.hasText((String)value) ? Normalizer.normalize(value, Normalizer.Form.NFKD).replaceAll("\\p{M}", "") : value;
    }

    private void validate(ProjectRequest request, InitializrMetadata metadata) {
        this.validatePlatformVersion(request, metadata);
        this.validateType(request.getType(), metadata);
        this.validateLanguage(request.getLanguage(), metadata);
        this.validatePackaging(request.getPackaging(), metadata);
        this.validateDependencies(request, metadata);
    }

    private void validatePlatformVersion(ProjectRequest request, InitializrMetadata metadata) {
        Version platformVersion = Version.safeParse((String)request.getBootVersion());
        InitializrConfiguration.Platform platform = metadata.getConfiguration().getEnv().getPlatform();
        if (platformVersion != null && !platform.isCompatibleVersion(platformVersion)) {
            throw new InvalidProjectRequestException("Invalid Spring Boot version '" + platformVersion + "', Spring Boot compatibility range is " + platform.determineCompatibilityRangeRequirement());
        }
    }

    private void validateType(String type, InitializrMetadata metadata) {
        if (type != null) {
            Type typeFromMetadata = metadata.getTypes().get(type);
            if (typeFromMetadata == null) {
                throw new InvalidProjectRequestException("Unknown type '" + type + "' check project metadata");
            }
            if (!typeFromMetadata.getTags().containsKey("build")) {
                throw new InvalidProjectRequestException("Invalid type '" + type + "' (missing build tag) check project metadata");
            }
        }
    }

    private void validateLanguage(String language, InitializrMetadata metadata) {
        DefaultMetadataElement languageFromMetadata;
        if (language != null && (languageFromMetadata = metadata.getLanguages().get(language)) == null) {
            throw new InvalidProjectRequestException("Unknown language '" + language + "' check project metadata");
        }
    }

    private void validatePackaging(String packaging, InitializrMetadata metadata) {
        DefaultMetadataElement packagingFromMetadata;
        if (packaging != null && (packagingFromMetadata = metadata.getPackagings().get(packaging)) == null) {
            throw new InvalidProjectRequestException("Unknown packaging '" + packaging + "' check project metadata");
        }
    }

    private void validateDependencies(ProjectRequest request, InitializrMetadata metadata) {
        List<String> dependencies = request.getDependencies();
        dependencies.forEach(dep -> {
            Dependency dependency = metadata.getDependencies().get(dep);
            if (dependency == null) {
                throw new InvalidProjectRequestException("Unknown dependency '" + dep + "' check project metadata");
            }
        });
    }

    private void validateDependencyRange(Version platformVersion, List<Dependency> resolvedDependencies) {
        resolvedDependencies.forEach(dep -> {
            if (!dep.match(platformVersion)) {
                throw new InvalidProjectRequestException("Dependency '" + dep.getId() + "' is not compatible with Spring Boot " + platformVersion);
            }
        });
    }

    private BuildSystem getBuildSystem(ProjectRequest request, InitializrMetadata metadata) {
        Map typeTags = metadata.getTypes().get(request.getType()).getTags();
        String id = (String)typeTags.get("build");
        String dialect = (String)typeTags.get("dialect");
        return BuildSystem.forIdAndDialect((String)id, (String)dialect);
    }

    private Version getPlatformVersion(ProjectRequest request, InitializrMetadata metadata) {
        String versionText = request.getBootVersion() != null ? request.getBootVersion() : metadata.getBootVersions().getDefault().getId();
        Version version = Version.parse((String)versionText);
        return this.platformVersionTransformer.transform(version, metadata);
    }

    private List<Dependency> getResolvedDependencies(ProjectRequest request, Version platformVersion, InitializrMetadata metadata) {
        List<String> depIds = request.getDependencies();
        return depIds.stream().map(it -> {
            Dependency dependency = metadata.getDependencies().get(it);
            return dependency.resolve(platformVersion);
        }).collect(Collectors.toList());
    }
}

