/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.autoconfigure;

import io.spring.initializr.web.support.Agent;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.util.UrlPathHelper;

public class InitializrWebConfig
implements WebMvcConfigurer {
    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/info", "/actuator/info");
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentTypeStrategy((ContentNegotiationStrategy)new CommandLineContentNegotiationStrategy());
    }

    private static final class CommandLineContentNegotiationStrategy
    implements ContentNegotiationStrategy {
        private final UrlPathHelper urlPathHelper = new UrlPathHelper();

        private CommandLineContentNegotiationStrategy() {
        }

        public List<MediaType> resolveMediaTypes(NativeWebRequest request) {
            Agent agent;
            String path = this.urlPathHelper.getPathWithinApplication((HttpServletRequest)request.getNativeRequest(HttpServletRequest.class));
            if (!StringUtils.hasText((String)path) || !path.equals("/")) {
                return MEDIA_TYPE_ALL_LIST;
            }
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null && (agent = Agent.fromUserAgent(userAgent)) != null && (Agent.AgentId.CURL.equals((Object)agent.getId()) || Agent.AgentId.HTTPIE.equals((Object)agent.getId()))) {
                return Collections.singletonList(MediaType.TEXT_PLAIN);
            }
            return Collections.singletonList(MediaType.APPLICATION_JSON);
        }
    }
}

