/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.controller;

import io.spring.initializr.generator.version.Version;
import io.spring.initializr.metadata.DependencyMetadata;
import io.spring.initializr.metadata.DependencyMetadataProvider;
import io.spring.initializr.metadata.InitializrConfiguration;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.InitializrMetadataProvider;
import io.spring.initializr.metadata.InvalidInitializrMetadataException;
import io.spring.initializr.web.controller.AbstractMetadataController;
import io.spring.initializr.web.mapper.DependencyMetadataJsonMapper;
import io.spring.initializr.web.mapper.DependencyMetadataV21JsonMapper;
import io.spring.initializr.web.mapper.InitializrMetadataJsonMapper;
import io.spring.initializr.web.mapper.InitializrMetadataV21JsonMapper;
import io.spring.initializr.web.mapper.InitializrMetadataV22JsonMapper;
import io.spring.initializr.web.mapper.InitializrMetadataV2JsonMapper;
import io.spring.initializr.web.mapper.InitializrMetadataVersion;
import io.spring.initializr.web.project.InvalidProjectRequestException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProjectMetadataController
extends AbstractMetadataController {
    public static final MediaType HAL_JSON_CONTENT_TYPE = MediaType.parseMediaType((String)"application/hal+json");
    private final DependencyMetadataProvider dependencyMetadataProvider;

    public ProjectMetadataController(InitializrMetadataProvider metadataProvider, DependencyMetadataProvider dependencyMetadataProvider) {
        super(metadataProvider);
        this.dependencyMetadataProvider = dependencyMetadataProvider;
    }

    @GetMapping(path={"/metadata/config"}, produces={"application/json"})
    public InitializrMetadata config() {
        return this.metadataProvider.get();
    }

    @GetMapping(path={"/", "/metadata/client"}, produces={"application/hal+json"})
    public ResponseEntity<String> serviceCapabilitiesHal() {
        return this.serviceCapabilitiesFor(InitializrMetadataVersion.V2_1, HAL_JSON_CONTENT_TYPE);
    }

    @GetMapping(path={"/", "/metadata/client"}, produces={"application/vnd.initializr.v2.2+json"})
    public ResponseEntity<String> serviceCapabilitiesV22() {
        return this.serviceCapabilitiesFor(InitializrMetadataVersion.V2_2);
    }

    @GetMapping(path={"/", "/metadata/client"}, produces={"application/vnd.initializr.v2.1+json", "application/json"})
    public ResponseEntity<String> serviceCapabilitiesV21() {
        return this.serviceCapabilitiesFor(InitializrMetadataVersion.V2_1);
    }

    @GetMapping(path={"/", "/metadata/client"}, produces={"application/vnd.initializr.v2+json"})
    public ResponseEntity<String> serviceCapabilitiesV2() {
        return this.serviceCapabilitiesFor(InitializrMetadataVersion.V2);
    }

    @GetMapping(path={"/dependencies"}, produces={"application/vnd.initializr.v2.2+json"})
    public ResponseEntity<String> dependenciesV22(@RequestParam(required=false) String bootVersion) {
        return this.dependenciesFor(InitializrMetadataVersion.V2_2, bootVersion);
    }

    @GetMapping(path={"/dependencies"}, produces={"application/vnd.initializr.v2.1+json", "application/json"})
    public ResponseEntity<String> dependenciesV21(@RequestParam(required=false) String bootVersion) {
        return this.dependenciesFor(InitializrMetadataVersion.V2_1, bootVersion);
    }

    @ExceptionHandler
    public void invalidMetadataRequest(HttpServletResponse response, InvalidInitializrMetadataException ex) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value(), ex.getMessage());
    }

    @ExceptionHandler
    public void invalidProjectRequest(HttpServletResponse response, InvalidProjectRequestException ex) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value(), ex.getMessage());
    }

    protected CacheControl determineCacheControlFor(InitializrMetadata metadata) {
        return CacheControl.maxAge((long)2L, (TimeUnit)TimeUnit.HOURS);
    }

    protected ResponseEntity<String> dependenciesFor(InitializrMetadataVersion metadataVersion, String bootVersion) {
        InitializrMetadata metadata = this.metadataProvider.get();
        Version effectiveBootVersion = bootVersion != null ? Version.parse((String)bootVersion) : Version.parse((String)metadata.getBootVersions().getDefault().getId());
        InitializrConfiguration.Platform platform = metadata.getConfiguration().getEnv().getPlatform();
        if (!platform.isCompatibleVersion(effectiveBootVersion)) {
            throw new InvalidProjectRequestException("Invalid Spring Boot version '" + bootVersion + "', Spring Boot compatibility range is " + platform.determineCompatibilityRangeRequirement());
        }
        DependencyMetadata dependencyMetadata = this.dependencyMetadataProvider.get(metadata, effectiveBootVersion);
        String content = this.createDependencyJsonMapper(metadataVersion).write(dependencyMetadata);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(metadataVersion.getMediaType()).eTag(this.createUniqueId(content))).cacheControl(this.determineCacheControlFor(metadata))).body((Object)content);
    }

    private ResponseEntity<String> serviceCapabilitiesFor(InitializrMetadataVersion metadataVersion) {
        return this.serviceCapabilitiesFor(metadataVersion, metadataVersion.getMediaType());
    }

    protected ResponseEntity<String> serviceCapabilitiesFor(InitializrMetadataVersion metadataVersion, MediaType contentType) {
        String appUrl = this.generateAppUrl();
        InitializrMetadata metadata = this.metadataProvider.get();
        String content = this.createMetadataJsonMapper(metadataVersion).write(metadata, appUrl);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(contentType).eTag(this.createUniqueId(content))).varyBy(new String[]{"Accept"})).cacheControl(this.determineCacheControlFor(metadata))).body((Object)content);
    }

    protected InitializrMetadataJsonMapper createMetadataJsonMapper(InitializrMetadataVersion metadataVersion) {
        return switch (metadataVersion) {
            case InitializrMetadataVersion.V2 -> new InitializrMetadataV2JsonMapper();
            case InitializrMetadataVersion.V2_1 -> new InitializrMetadataV21JsonMapper();
            default -> new InitializrMetadataV22JsonMapper();
        };
    }

    protected DependencyMetadataJsonMapper createDependencyJsonMapper(InitializrMetadataVersion metadataVersion) {
        return new DependencyMetadataV21JsonMapper();
    }
}

