/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.DependencyMetadata;
import io.spring.initializr.metadata.Repository;
import io.spring.initializr.web.mapper.DependencyMetadataJsonMapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class DependencyMetadataV21JsonMapper
implements DependencyMetadataJsonMapper {
    private static final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;

    @Override
    public String write(DependencyMetadata metadata) {
        ObjectNode parent = nodeFactory.objectNode();
        parent.put("bootVersion", metadata.getBootVersion().toString());
        parent.set("dependencies", (JsonNode)this.mapDependencies(metadata.getDependencies()));
        parent.set("repositories", (JsonNode)this.mapRepositories(metadata.getRepositories()));
        parent.set("boms", (JsonNode)this.mapBoms(metadata.getBoms()));
        this.customizeParent(parent, metadata);
        return parent.toString();
    }

    protected void customizeParent(ObjectNode parent, DependencyMetadata metadata) {
    }

    private static ObjectNode mapDependency(Dependency dep) {
        ObjectNode node = nodeFactory.objectNode();
        node.put("groupId", dep.getGroupId());
        node.put("artifactId", dep.getArtifactId());
        node.put("scope", dep.getScope());
        DependencyMetadataV21JsonMapper.addIfNotNull(node, "version", dep.getVersion());
        DependencyMetadataV21JsonMapper.addIfNotNull(node, "bom", dep.getBom());
        DependencyMetadataV21JsonMapper.addIfNotNull(node, "repository", dep.getRepository());
        return node;
    }

    private static void addIfNotNull(ObjectNode node, String key, String value) {
        if (value != null) {
            node.put(key, value);
        }
    }

    private static JsonNode mapRepository(Repository repo) {
        ObjectNode node = nodeFactory.objectNode();
        node.put("name", repo.getName()).put("url", repo.getUrl() != null ? repo.getUrl().toString() : null).put("snapshotEnabled", repo.isSnapshotsEnabled());
        return node;
    }

    private static ObjectNode mapBom(BillOfMaterials bom) {
        ObjectNode node = nodeFactory.objectNode();
        node.put("groupId", bom.getGroupId());
        node.put("artifactId", bom.getArtifactId());
        DependencyMetadataV21JsonMapper.addIfNotNull(node, "version", bom.getVersion());
        DependencyMetadataV21JsonMapper.addArrayIfNotNull(node, bom.getRepositories());
        return node;
    }

    private static void addArrayIfNotNull(ObjectNode node, List<String> values) {
        if (!CollectionUtils.isEmpty(values)) {
            ArrayNode arrayNode = nodeFactory.arrayNode();
            values.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
            node.set("repositories", (JsonNode)arrayNode);
        }
    }

    private static ObjectNode mapNode(Map<String, JsonNode> content) {
        ObjectNode node = nodeFactory.objectNode();
        content.forEach((arg_0, arg_1) -> ((ObjectNode)node).set(arg_0, arg_1));
        return node;
    }

    private ObjectNode mapDependencies(Map<String, Dependency> dependencies) {
        return DependencyMetadataV21JsonMapper.mapNode(dependencies.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DependencyMetadataV21JsonMapper.mapDependency((Dependency)entry.getValue()))));
    }

    private ObjectNode mapRepositories(Map<String, Repository> repositories) {
        return DependencyMetadataV21JsonMapper.mapNode(repositories.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DependencyMetadataV21JsonMapper.mapRepository((Repository)entry.getValue()))));
    }

    private ObjectNode mapBoms(Map<String, BillOfMaterials> boms) {
        return DependencyMetadataV21JsonMapper.mapNode(boms.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DependencyMetadataV21JsonMapper.mapBom((BillOfMaterials)entry.getValue()))));
    }
}

