/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.project;

import io.spring.initializr.generator.project.MutableProjectDescription;
import io.spring.initializr.generator.project.ProjectDescriptionCustomizer;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.metadata.InitializrMetadata;
import java.util.function.Supplier;
import org.springframework.util.StringUtils;

public class MetadataProjectDescriptionCustomizer
implements ProjectDescriptionCustomizer {
    private static final char[] VALID_MAVEN_SPECIAL_CHARACTERS = new char[]{'_', '-', '.'};
    private final InitializrMetadata metadata;

    public MetadataProjectDescriptionCustomizer(InitializrMetadata metadata) {
        this.metadata = metadata;
    }

    public void customize(MutableProjectDescription description) {
        if (!StringUtils.hasText((String)description.getApplicationName())) {
            description.setApplicationName(this.metadata.getConfiguration().generateApplicationName(description.getName()));
        }
        String targetArtifactId = this.determineValue(description.getArtifactId(), () -> this.metadata.getArtifactId().getContent());
        description.setArtifactId(this.cleanMavenCoordinate(targetArtifactId, "-"));
        if (targetArtifactId.equals(description.getBaseDirectory())) {
            description.setBaseDirectory(this.cleanMavenCoordinate(targetArtifactId, "-"));
        }
        if (!StringUtils.hasText((String)description.getDescription())) {
            description.setDescription(this.metadata.getDescription().getContent());
        }
        String targetGroupId = this.determineValue(description.getGroupId(), () -> this.metadata.getGroupId().getContent());
        description.setGroupId(this.cleanMavenCoordinate(targetGroupId, "."));
        if (!StringUtils.hasText((String)description.getName())) {
            description.setName(this.metadata.getName().getContent());
        } else if (targetArtifactId.equals(description.getName())) {
            description.setName(this.cleanMavenCoordinate(targetArtifactId, "-"));
        }
        description.setPackageName(this.metadata.getConfiguration().cleanPackageName(description.getPackageName(), description.getLanguage(), this.metadata.getPackageName().getContent()));
        if (description.getPlatformVersion() == null) {
            description.setPlatformVersion(Version.parse((String)this.metadata.getBootVersions().getDefault().getId()));
        }
        if (!StringUtils.hasText((String)description.getVersion())) {
            description.setVersion(this.metadata.getVersion().getContent());
        }
    }

    private String cleanMavenCoordinate(String coordinate, String delimiter) {
        String[] elements = coordinate.split("[^\\w\\-.]+");
        if (elements.length == 1) {
            return coordinate;
        }
        StringBuilder builder = new StringBuilder();
        for (String element : elements) {
            if (this.shouldAppendDelimiter(element, builder)) {
                builder.append(delimiter);
            }
            builder.append(element);
        }
        return builder.toString();
    }

    private boolean shouldAppendDelimiter(String element, StringBuilder builder) {
        if (builder.isEmpty()) {
            return false;
        }
        for (char c : VALID_MAVEN_SPECIAL_CHARACTERS) {
            int prevIndex = builder.length() - 1;
            if (element.charAt(0) != c && builder.charAt(prevIndex) != c) continue;
            return false;
        }
        return true;
    }

    private String determineValue(String candidate, Supplier<String> fallback) {
        return StringUtils.hasText((String)candidate) ? candidate : fallback.get();
    }
}

