/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.project;

import io.spring.initializr.generator.buildsystem.BuildItemResolver;
import io.spring.initializr.generator.buildsystem.BuildWriter;
import io.spring.initializr.generator.project.DefaultProjectAssetGenerator;
import io.spring.initializr.generator.project.ProjectAssetGenerator;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.ProjectGenerationContext;
import io.spring.initializr.generator.project.ProjectGenerationException;
import io.spring.initializr.generator.project.ProjectGenerator;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.InitializrMetadataProvider;
import io.spring.initializr.metadata.support.MetadataBuildItemResolver;
import io.spring.initializr.web.project.MetadataProjectDescriptionCustomizer;
import io.spring.initializr.web.project.ProjectFailedEvent;
import io.spring.initializr.web.project.ProjectGeneratedEvent;
import io.spring.initializr.web.project.ProjectGenerationResult;
import io.spring.initializr.web.project.ProjectRequest;
import io.spring.initializr.web.project.ProjectRequestToDescriptionConverter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.util.FileSystemUtils;

public class ProjectGenerationInvoker<R extends ProjectRequest> {
    private final ApplicationContext parentApplicationContext;
    private final ApplicationEventPublisher eventPublisher;
    private final ProjectRequestToDescriptionConverter<R> requestConverter;
    private final ProjectAssetGenerator<Path> projectAssetGenerator = new DefaultProjectAssetGenerator();
    private final Map<Path, List<Path>> temporaryFiles = new ConcurrentHashMap<Path, List<Path>>();

    public ProjectGenerationInvoker(ApplicationContext parentApplicationContext, ProjectRequestToDescriptionConverter<R> requestConverter) {
        this(parentApplicationContext, (ApplicationEventPublisher)parentApplicationContext, requestConverter);
    }

    protected ProjectGenerationInvoker(ApplicationContext parentApplicationContext, ApplicationEventPublisher eventPublisher, ProjectRequestToDescriptionConverter<R> requestConverter) {
        this.parentApplicationContext = parentApplicationContext;
        this.eventPublisher = eventPublisher;
        this.requestConverter = requestConverter;
    }

    public ProjectGenerationResult invokeProjectStructureGeneration(R request) {
        InitializrMetadata metadata = ((InitializrMetadataProvider)this.parentApplicationContext.getBean(InitializrMetadataProvider.class)).get();
        try {
            ProjectDescription description = this.requestConverter.convert(request, metadata);
            ProjectGenerator projectGenerator = this.createProjectGenerator(metadata);
            ProjectGenerationResult result = (ProjectGenerationResult)projectGenerator.generate(description, this.generateProject(description, request));
            this.addTempFile(result.getRootDirectory(), result.getRootDirectory());
            return result;
        }
        catch (ProjectGenerationException ex) {
            this.publishProjectFailedEvent(request, metadata, (Exception)((Object)ex));
            throw ex;
        }
    }

    private ProjectAssetGenerator<ProjectGenerationResult> generateProject(ProjectDescription description, R request) {
        return context -> {
            Path projectDir = (Path)this.getProjectAssetGenerator(description).generate(context);
            this.publishProjectGeneratedEvent(request, context);
            return new ProjectGenerationResult((ProjectDescription)context.getBean(ProjectDescription.class), projectDir);
        };
    }

    protected ProjectAssetGenerator<Path> getProjectAssetGenerator(ProjectDescription description) {
        return this.projectAssetGenerator;
    }

    public byte[] invokeBuildGeneration(R request) {
        InitializrMetadata metadata = ((InitializrMetadataProvider)this.parentApplicationContext.getBean(InitializrMetadataProvider.class)).get();
        try {
            ProjectDescription description = this.requestConverter.convert(request, metadata);
            ProjectGenerator projectGenerator = this.createProjectGenerator(metadata);
            return (byte[])projectGenerator.generate(description, this.generateBuild(request));
        }
        catch (ProjectGenerationException ex) {
            this.publishProjectFailedEvent(request, metadata, (Exception)((Object)ex));
            throw ex;
        }
    }

    protected ProjectGenerator createProjectGenerator(InitializrMetadata metadata) {
        return new ProjectGenerator(projectGenerationContext -> this.customizeProjectGenerationContext((AnnotationConfigApplicationContext)projectGenerationContext, metadata));
    }

    private ProjectAssetGenerator<byte[]> generateBuild(R request) {
        return context -> {
            byte[] content = this.generateBuild(context);
            this.publishProjectGeneratedEvent(request, context);
            return content;
        };
    }

    public Path createDistributionFile(Path dir, String extension) {
        Path download = dir.resolveSibling(String.valueOf(dir.getFileName()) + extension);
        this.addTempFile(dir, download);
        return download;
    }

    private void addTempFile(Path group, Path file) {
        this.temporaryFiles.compute(group, (path, paths) -> {
            List newPaths = paths != null ? paths : new ArrayList();
            newPaths.add(file);
            return newPaths;
        });
    }

    public void cleanTempFiles(Path dir) {
        List<Path> tempFiles = this.temporaryFiles.remove(dir);
        if (!tempFiles.isEmpty()) {
            tempFiles.forEach(path -> {
                try {
                    FileSystemUtils.deleteRecursively((Path)path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    private byte[] generateBuild(ProjectGenerationContext context) throws IOException {
        ProjectDescription description = (ProjectDescription)context.getBean(ProjectDescription.class);
        StringWriter out = new StringWriter();
        BuildWriter buildWriter = (BuildWriter)context.getBeanProvider(BuildWriter.class).getIfAvailable();
        if (buildWriter != null) {
            buildWriter.writeBuild((Writer)out);
            return out.toString().getBytes();
        }
        throw new IllegalStateException("No BuildWriter implementation found for " + String.valueOf(description.getLanguage()));
    }

    private void customizeProjectGenerationContext(AnnotationConfigApplicationContext context, InitializrMetadata metadata) {
        context.setParent(this.parentApplicationContext);
        context.registerBean(InitializrMetadata.class, () -> metadata, new BeanDefinitionCustomizer[0]);
        context.registerBean(BuildItemResolver.class, () -> new MetadataBuildItemResolver(metadata, ((ProjectDescription)context.getBean(ProjectDescription.class)).getPlatformVersion()), new BeanDefinitionCustomizer[0]);
        context.registerBean(MetadataProjectDescriptionCustomizer.class, () -> new MetadataProjectDescriptionCustomizer(metadata), new BeanDefinitionCustomizer[0]);
    }

    private void publishProjectGeneratedEvent(R request, ProjectGenerationContext context) {
        InitializrMetadata metadata = (InitializrMetadata)context.getBean(InitializrMetadata.class);
        ProjectGeneratedEvent event = new ProjectGeneratedEvent((ProjectRequest)request, metadata);
        this.eventPublisher.publishEvent((Object)event);
    }

    private void publishProjectFailedEvent(R request, InitializrMetadata metadata, Exception cause) {
        ProjectFailedEvent event = new ProjectFailedEvent((ProjectRequest)request, metadata, cause);
        this.eventPublisher.publishEvent((Object)event);
    }
}

