/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;

public class SpringMethodVisibilityCheck
extends AbstractSpringCheck {
    public int[] getAcceptableTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        if (modifiers.findFirstToken(62) != null) {
            this.visitPublicMethod(modifiers, ast);
        }
    }

    private void visitPublicMethod(DetailAST modifiers, DetailAST method) {
        if (this.hasOverrideAnnotation(modifiers)) {
            return;
        }
        DetailAST classDef = this.getClassDef(method.getParent());
        if (classDef == null) {
            return;
        }
        DetailAST classModifiers = classDef.findFirstToken(5);
        if (classModifiers.findFirstToken(62) != null || classModifiers.findFirstToken(63) != null) {
            return;
        }
        DetailAST ident = method.findFirstToken(58);
        this.log(ident.getLineNo(), ident.getColumnNo(), "methodvisibility.publicMethod", new Object[]{ident.getText()});
    }

    private boolean hasOverrideAnnotation(DetailAST modifiers) {
        for (DetailAST candidate = modifiers.getFirstChild(); candidate != null; candidate = candidate.getNextSibling()) {
            DetailAST dot;
            String name;
            if (candidate.getType() != 159 || !"Override".equals(name = ((dot = candidate.findFirstToken(59)) != null ? dot : candidate).findFirstToken(58).getText())) continue;
            return true;
        }
        return false;
    }

    private DetailAST getClassDef(DetailAST ast) {
        while (ast != null) {
            if (ast.getType() == 14) {
                return ast;
            }
            ast = ast.getParent();
        }
        return null;
    }
}

