/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SpringJUnit5Check
extends AbstractSpringCheck {
    private static final String JUNIT4_TEST_ANNOTATION = "org.junit.Test";
    private static final List<String> TEST_ANNOTATIONS;
    private static final List<String> LIFECYCLE_ANNOTATIONS;
    private static final Set<String> BANNED_IMPORTS;
    private List<String> unlessImports = new ArrayList<String>();
    private final List<DetailAST> testMethods = new ArrayList<DetailAST>();
    private final Map<String, FullIdent> imports = new LinkedHashMap<String, FullIdent>();
    private final List<DetailAST> lifecycleMethods = new ArrayList<DetailAST>();

    private static void addAnnotation(Set<String> annotations, String annotation) {
        annotations.add(annotation);
        int lastDot = annotation.lastIndexOf(".");
        if (lastDot != -1) {
            annotations.add(annotation.substring(lastDot + 1));
        }
    }

    public int[] getAcceptableTokens() {
        return new int[]{9, 30};
    }

    public void beginTree(DetailAST rootAST) {
        this.imports.clear();
        this.testMethods.clear();
        this.lifecycleMethods.clear();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 9: {
                this.visitMethodDef(ast);
            }
            case 30: {
                this.visitImport(ast);
            }
        }
    }

    private void visitMethodDef(DetailAST ast) {
        if (AnnotationUtil.containsAnnotation((DetailAST)ast, TEST_ANNOTATIONS)) {
            this.testMethods.add(ast);
        }
        if (AnnotationUtil.containsAnnotation((DetailAST)ast, LIFECYCLE_ANNOTATIONS)) {
            this.lifecycleMethods.add(ast);
        }
    }

    private void visitImport(DetailAST ast) {
        FullIdent ident = FullIdent.createFullIdentBelow((DetailAST)ast);
        this.imports.put(ident.getText(), ident);
    }

    public void finishTree(DetailAST rootAST) {
        if (this.shouldCheck()) {
            this.check();
        }
    }

    private boolean shouldCheck() {
        if (this.testMethods.isEmpty() && this.lifecycleMethods.isEmpty()) {
            return false;
        }
        for (String unlessImport : this.unlessImports) {
            if (!this.imports.containsKey(unlessImport)) continue;
            return false;
        }
        return true;
    }

    private void check() {
        for (String bannedImport : BANNED_IMPORTS) {
            FullIdent ident = this.imports.get(bannedImport);
            if (ident == null) continue;
            this.log(ident.getLineNo(), ident.getColumnNo(), "junit5.bannedImport", new Object[]{bannedImport});
        }
        for (DetailAST testMethod : this.testMethods) {
            if (!AnnotationUtil.containsAnnotation((DetailAST)testMethod, (String)JUNIT4_TEST_ANNOTATION)) continue;
            this.log(testMethod, "junit5.bannedTestAnnotation");
        }
        this.checkMethodVisibility(this.testMethods, "junit5.testPublicMethod", "junit5.testPrivateMethod");
        this.checkMethodVisibility(this.lifecycleMethods, "junit5.lifecyclePublicMethod", "junit5.lifecyclePrivateMethod");
    }

    private void checkMethodVisibility(List<DetailAST> methods, String publicMessageKey, String privateMessageKey) {
        for (DetailAST method : methods) {
            DetailAST modifiers = method.findFirstToken(5);
            if (modifiers.findFirstToken(62) != null) {
                this.log(method, publicMessageKey);
            }
            if (modifiers.findFirstToken(61) == null) continue;
            this.log(method, privateMessageKey);
        }
    }

    private void log(DetailAST method, String key) {
        String name = method.findFirstToken(58).getText();
        this.log(method.getLineNo(), method.getColumnNo(), key, new Object[]{name});
    }

    public void setUnlessImports(String unlessImports) {
        this.unlessImports = Collections.unmodifiableList(Arrays.stream(unlessImports.split(",")).map(String::trim).collect(Collectors.toList()));
    }

    static {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        SpringJUnit5Check.addAnnotation(annotations, JUNIT4_TEST_ANNOTATION);
        SpringJUnit5Check.addAnnotation(annotations, "org.junit.jupiter.api.RepeatedTest");
        SpringJUnit5Check.addAnnotation(annotations, "org.junit.jupiter.api.Test");
        SpringJUnit5Check.addAnnotation(annotations, "org.junit.jupiter.api.TestFactory");
        SpringJUnit5Check.addAnnotation(annotations, "org.junit.jupiter.api.TestTemplate");
        SpringJUnit5Check.addAnnotation(annotations, "org.junit.jupiter.params.ParameterizedTest");
        TEST_ANNOTATIONS = Collections.unmodifiableList(new ArrayList<String>(annotations));
        annotations = new LinkedHashSet();
        SpringJUnit5Check.addAnnotation(annotations, "org.junit.jupiter.api.BeforeAll");
        SpringJUnit5Check.addAnnotation(annotations, "org.junit.jupiter.api.BeforeEach");
        SpringJUnit5Check.addAnnotation(annotations, "org.junit.jupiter.api.AfterAll");
        SpringJUnit5Check.addAnnotation(annotations, "org.junit.jupiter.api.AfterEach");
        LIFECYCLE_ANNOTATIONS = Collections.unmodifiableList(new ArrayList<String>(annotations));
        LinkedHashSet<String> bannedImports = new LinkedHashSet<String>();
        bannedImports.add(JUNIT4_TEST_ANNOTATION);
        bannedImports.add("org.junit.After");
        bannedImports.add("org.junit.AfterClass");
        bannedImports.add("org.junit.Before");
        bannedImports.add("org.junit.BeforeClass");
        bannedImports.add("org.junit.Rule");
        bannedImports.add("org.junit.ClassRule");
        BANNED_IMPORTS = Collections.unmodifiableSet(bannedImports);
    }
}

