/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SpringHeaderCheck
extends AbstractFileSetCheck {
    private static final String UNCHECKED = "unchecked";
    private static final String NONE = "none";
    public static final String DEFAULT_HEADER_TYPE = "apache2";
    public static final String DEFAULT_HEADER_COPYRIGHT_PATTERN = "20\\d\\d(-20\\d\\d)?";
    private static final String DEFAULT_CHARSET = System.getProperty("file.encoding", StandardCharsets.UTF_8.name());
    private String charset = DEFAULT_CHARSET;
    private String headerType = "apache2";
    private URI headerFile;
    private String headerCopyrightPattern = "20\\d\\d(-20\\d\\d)?";
    private String packageInfoHeaderType;
    private URI packageInfoHeaderFile;
    private HeaderCheck check;
    private HeaderCheck packageInfoCheck;

    protected void finishLocalSetup() throws CheckstyleException {
        try {
            this.check = this.createCheck(this.headerType, this.headerFile);
            String packageInfoHeaderType = this.packageInfoHeaderType != null ? this.packageInfoHeaderType : this.headerType;
            URI packageInfoHeaderFile = this.packageInfoHeaderFile != null ? this.packageInfoHeaderFile : this.headerFile;
            this.packageInfoCheck = this.createCheck(packageInfoHeaderType, packageInfoHeaderFile);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private HeaderCheck createCheck(String headerType, URI headerFile) throws IOException {
        if (UNCHECKED.equals(headerType)) {
            return HeaderCheck.NONE;
        }
        if (NONE.equals(headerType)) {
            return new NoHeaderCheck();
        }
        return new RegexHeaderCheck(headerType, headerFile);
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        this.getCheck(file).run(fileText);
    }

    private HeaderCheck getCheck(File file) {
        if (file.getName().startsWith("package-info")) {
            return this.packageInfoCheck;
        }
        return this.check;
    }

    public void setCharset(String charset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(charset)) {
            throw new UnsupportedEncodingException("unsupported charset: '" + charset + "'");
        }
        this.charset = charset;
    }

    public void setHeaderType(String headerType) {
        this.headerType = headerType;
    }

    public void setHeaderFile(URI headerFile) throws CheckstyleException {
        this.headerFile = headerFile;
    }

    public void setHeaderCopyrightPattern(String headerCopyrightPattern) {
        this.headerCopyrightPattern = headerCopyrightPattern;
    }

    public void setPackageInfoHeaderType(String packageInfoHeaderType) {
        this.packageInfoHeaderType = packageInfoHeaderType;
    }

    public void setPackageInfoHeaderFile(URI packageInfoHeaderFile) {
        this.packageInfoHeaderFile = packageInfoHeaderFile;
    }

    private class NoHeaderCheck
    implements HeaderCheck {
        private NoHeaderCheck() {
        }

        @Override
        public boolean run(FileText fileText) {
            for (int i = 0; i < fileText.size(); ++i) {
                String fileLine = fileText.get(i);
                if (fileLine.trim().isEmpty()) continue;
                if (this.isHeaderComment(fileLine)) {
                    SpringHeaderCheck.this.log(i, "header.unexpected", new Object[0]);
                    return false;
                }
                return true;
            }
            return true;
        }

        private boolean isHeaderComment(String fileLine) {
            return (fileLine.contains("/*") || fileLine.contains("//")) && !fileLine.contains("/**");
        }
    }

    private class RegexHeaderCheck
    implements HeaderCheck {
        private final List<Pattern> lines;

        RegexHeaderCheck(String type, URI file) throws IOException {
            this.lines = this.loadLines(this.openInputStream(type, file));
        }

        private InputStream openInputStream(String type, URI file) throws IOException {
            if (file != null) {
                return file.toURL().openStream();
            }
            String name = "header-" + type + ".txt";
            InputStream inputStream = SpringHeaderCheck.class.getResourceAsStream(name);
            if (inputStream == null) {
                throw new IllegalStateException("Unknown header type " + type);
            }
            return inputStream;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private List<Pattern> loadLines(InputStream inputStream) throws IOException {
            inputStream = new BufferedInputStream(inputStream);
            try (InputStreamReader reader = new InputStreamReader(inputStream, SpringHeaderCheck.this.charset);){
                LineNumberReader lineReader = new LineNumberReader(reader);
                ArrayList<Pattern> lines = new ArrayList<Pattern>();
                while (true) {
                    String line;
                    if ((line = lineReader.readLine()) == null) {
                        ArrayList<Pattern> arrayList = lines;
                        return arrayList;
                    }
                    lines.add(this.loadLine(line, SpringHeaderCheck.this.headerCopyrightPattern));
                    continue;
                    break;
                }
            }
        }

        private Pattern loadLine(String line, String copyrightPattern) {
            line = line.replace("${copyright-pattern}", "\\E" + copyrightPattern + "\\Q");
            line = "^\\Q" + line + "\\E$";
            return Pattern.compile(line);
        }

        @Override
        public boolean run(FileText fileText) {
            if (this.lines.size() > fileText.size()) {
                SpringHeaderCheck.this.log(1, "header.missing", new Object[0]);
                return false;
            }
            for (int i = 0; i < this.lines.size(); ++i) {
                String fileLine = fileText.get(i);
                Pattern pattern = this.lines.get(i);
                if (pattern.matcher(fileLine).matches()) continue;
                SpringHeaderCheck.this.log(i + 1, "header.mismatch", new Object[]{pattern});
                return false;
            }
            return true;
        }
    }

    private static interface HeaderCheck {
        public static final HeaderCheck NONE = fileText -> true;

        public boolean run(FileText var1);
    }
}

