/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpringJavadocCheck
extends AbstractSpringCheck {
    private static final List<Pattern> CASE_CHECKED_TAG_PATTERNS;
    private static final List<Pattern> BANNED_TAGS;
    private static final Pattern SINCE_TAG_PATTERN;
    private static final Set<Integer> TOP_LEVEL_TYPES;
    private boolean requireSinceTag;
    private boolean publicOnlySinceTags;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 154, 157, 9, 8};
    }

    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157, 9, 8, 155, 161};
    }

    public void visitToken(DetailAST ast) {
        int lineNumber = ast.getLineNo();
        TextBlock javadoc = this.getFileContents().getJavadocBefore(lineNumber);
        if (javadoc != null) {
            this.checkJavadoc(ast, javadoc);
        }
    }

    private void checkJavadoc(DetailAST ast, TextBlock javadoc) {
        this.checkBannedTags(ast, javadoc);
        this.checkTagCase(ast, javadoc);
        this.checkSinceTag(ast, javadoc);
    }

    private void checkBannedTags(DetailAST ast, TextBlock javadoc) {
        String[] text = javadoc.getText();
        for (int i = 0; i < text.length; ++i) {
            for (Pattern pattern : BANNED_TAGS) {
                Matcher matcher = pattern.matcher(text[i]);
                if (!matcher.find()) continue;
                String tagName = matcher.group(1).trim();
                this.log(javadoc.getStartLineNo() + i, tagName.length(), "javadoc.bannedTag", new Object[]{tagName});
            }
        }
    }

    private void checkTagCase(DetailAST ast, TextBlock javadoc) {
        String[] text = javadoc.getText();
        for (int i = 0; i < text.length; ++i) {
            for (Pattern pattern : CASE_CHECKED_TAG_PATTERNS) {
                String description;
                Matcher matcher = pattern.matcher(text[i]);
                if (!matcher.find() || !this.startsWithUppercase(description = matcher.group(1).trim())) continue;
                this.log(javadoc.getStartLineNo() + i, text[i].length() - description.length(), "javadoc.badCase", new Object[0]);
            }
        }
    }

    private void checkSinceTag(DetailAST ast, TextBlock javadoc) {
        if (!TOP_LEVEL_TYPES.contains(ast.getType())) {
            return;
        }
        String[] text = javadoc.getText();
        DetailAST interfaceDef = this.getInterfaceDef(ast);
        boolean privateType = !this.isPublicOrProtected(ast) && (interfaceDef == null || !this.isPublicOrProtected(interfaceDef));
        boolean innerType = ast.getParent() != null;
        boolean found = false;
        for (int i = 0; i < text.length; ++i) {
            Matcher matcher = SINCE_TAG_PATTERN.matcher(text[i]);
            if (!matcher.find()) continue;
            found = true;
            String description = matcher.group(1).trim();
            if (!this.publicOnlySinceTags || !privateType) continue;
            this.log(javadoc.getStartLineNo() + i, text[i].length() - description.length(), "javadoc.publicSince", new Object[0]);
        }
        if (!(!this.requireSinceTag || innerType || found || this.publicOnlySinceTags && privateType)) {
            this.log(javadoc.getStartLineNo(), 0, "javadoc.missingSince", new Object[0]);
        }
    }

    private boolean startsWithUppercase(String description) {
        return description.length() > 0 && Character.isUpperCase(description.charAt(0));
    }

    public void setRequireSinceTag(boolean requireSinceTag) {
        this.requireSinceTag = requireSinceTag;
    }

    public void setPublicOnlySinceTags(boolean publicOnlySinceTags) {
        this.publicOnlySinceTags = publicOnlySinceTags;
    }

    private DetailAST getInterfaceDef(DetailAST ast) {
        return this.findParent(ast, 15);
    }

    private DetailAST findParent(DetailAST ast, int classDef) {
        while (ast != null) {
            if (ast.getType() == classDef) {
                return ast;
            }
            ast = ast.getParent();
        }
        return null;
    }

    private boolean isPublicOrProtected(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        if (modifiers == null) {
            return false;
        }
        return modifiers.findFirstToken(62) != null || modifiers.findFirstToken(63) != null;
    }

    static {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        patterns.add(Pattern.compile("@param\\s+\\S+\\s+(.*)"));
        patterns.add(Pattern.compile("@throws\\s+\\S+\\s+(.*)"));
        patterns.add(Pattern.compile("@return\\s+(.*)"));
        CASE_CHECKED_TAG_PATTERNS = Collections.unmodifiableList(patterns);
        patterns = new ArrayList();
        patterns.add(Pattern.compile("(@soundtrack)\\s+.*"));
        BANNED_TAGS = Collections.unmodifiableList(patterns);
        SINCE_TAG_PATTERN = Pattern.compile("@since\\s+(.*)");
        HashSet<Integer> topLevelTypes = new HashSet<Integer>();
        topLevelTypes.add(15);
        topLevelTypes.add(14);
        topLevelTypes.add(154);
        topLevelTypes.add(157);
        TOP_LEVEL_TYPES = Collections.unmodifiableSet(topLevelTypes);
    }
}

