/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SpringAnnotationLocationCheck
extends AbstractCheck {
    private static final Set<String> JSPECIFY_ANNOTATION_NAMES = new HashSet<String>(Arrays.asList("NonNull", "Nullable", "NullMarked", "NullUnmarked"));

    public int[] getDefaultTokens() {
        return new int[]{14, 15, 16, 155, 154, 9, 8, 10, 199, 203};
    }

    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 16, 155, 154, 9, 8, 10, 157, 161, 199, 203};
    }

    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() != 10 || ast.getParent().getType() == 6) {
            DetailAST node = ast.findFirstToken(5);
            node = node != null ? node : ast.findFirstToken(158);
            this.checkAnnotations(node, this.getExpectedAnnotationIndentation(node));
        }
    }

    private int getExpectedAnnotationIndentation(DetailAST node) {
        return node.getColumnNo();
    }

    private void checkAnnotations(DetailAST node, int correctIndentation) {
        for (DetailAST annotation = node.getFirstChild(); annotation != null && annotation.getType() == 159; annotation = annotation.getNextSibling()) {
            this.checkAnnotation(correctIndentation, annotation);
        }
    }

    private void checkAnnotation(int correctIndentation, DetailAST annotation) {
        String annotationName = this.getAnnotationName(annotation);
        if (!this.isCorrectLocation(annotation) && !this.isJSpecifyAnnotation(annotationName)) {
            this.log(annotation, "annotation.location.alone", new Object[]{annotationName});
        } else if (annotation.getColumnNo() != correctIndentation && !this.hasNodeBefore(annotation)) {
            this.log(annotation, "annotation.location", new Object[]{annotationName, annotation.getColumnNo(), correctIndentation});
        }
    }

    private String getAnnotationName(DetailAST annotation) {
        DetailAST identNode = annotation.findFirstToken(58);
        if (identNode == null) {
            identNode = annotation.findFirstToken(59).findFirstToken(58);
        }
        return identNode.getText();
    }

    private boolean isCorrectLocation(DetailAST annotation) {
        return !this.hasNodeBeside(annotation);
    }

    private boolean hasNodeBeside(DetailAST annotation) {
        return this.hasNodeBefore(annotation) || this.hasNodeAfter(annotation);
    }

    private boolean hasNodeBefore(DetailAST annotation) {
        int annotationLineNo = annotation.getLineNo();
        DetailAST previousNode = annotation.getPreviousSibling();
        return previousNode != null && annotationLineNo == previousNode.getLineNo();
    }

    private boolean hasNodeAfter(DetailAST annotation) {
        int annotationLineNo = annotation.getLineNo();
        DetailAST nextNode = annotation.getNextSibling();
        nextNode = nextNode != null ? nextNode : annotation.getParent().getNextSibling();
        return annotationLineNo == nextNode.getLineNo();
    }

    private boolean isJSpecifyAnnotation(String annotationName) {
        return JSPECIFY_ANNOTATION_NAMES.contains(annotationName);
    }
}

