/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;
import com.puppycrawl.tools.checkstyle.checks.whitespace.ParenPadCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Locale;

public class SpringParenPadCheck
extends ParenPadCheck {
    private static final char OPEN_PARENTHESIS = '(';
    private static final char CLOSE_PARENTHESIS = ')';
    private PadOption option = PadOption.NOSPACE;

    public void setOption(String optionStr) {
        this.option = PadOption.valueOf((String)optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    protected void processLeft(DetailAST ast) {
        String line = this.getLines()[ast.getLineNo() - 1];
        int[] codePoints = line.codePoints().toArray();
        int after = ast.getColumnNo() + 1;
        if (after < codePoints.length) {
            boolean hasWhitespaceAfter = this.isConsideredWhitespace(codePoints, after);
            if (this.option == PadOption.NOSPACE && hasWhitespaceAfter) {
                this.log(ast, "ws.followed", new Object[]{Character.valueOf('(')});
            } else if (this.option == PadOption.SPACE && !hasWhitespaceAfter && line.charAt(after) != ')') {
                this.log(ast, "ws.notFollowed", new Object[]{Character.valueOf('(')});
            }
        }
    }

    private boolean isConsideredWhitespace(int[] codePoints, int after) {
        if (CommonUtil.isCodePointWhitespace((int[])codePoints, (int)after)) {
            return !this.isSlashSlash(codePoints, after + 1);
        }
        return false;
    }

    private boolean isSlashSlash(int[] codePoints, int index) {
        if (index + 1 < codePoints.length) {
            char c1 = Character.toChars(codePoints[index])[0];
            char c2 = Character.toChars(codePoints[index + 1])[0];
            return c1 == '/' && c2 == '/';
        }
        return false;
    }
}

