/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;

public class SpringCatchCheck
extends AbstractCheck {
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{96};
    }

    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 96) {
            this.visitCatch(ast);
        }
    }

    private void visitCatch(DetailAST ast) {
        DetailAST child;
        for (child = ast.getFirstChild(); child != null && child.getType() != 21; child = child.getNextSibling()) {
        }
        if (child != null) {
            this.visitParameterDef(child);
        }
    }

    private void visitParameterDef(DetailAST ast) {
        DetailAST lastChild = ast.getLastChild();
        if (lastChild != null && lastChild.getType() == 58) {
            this.checkIdent(lastChild);
        }
    }

    private void checkIdent(DetailAST ast) {
        String text = ast.getText();
        if (text.length() == 1) {
            this.log(ast.getLineNo(), ast.getColumnNo(), "catch.singleLetter", new Object[0]);
        }
    }
}

