/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Locale;

public class SpringTernaryCheck
extends AbstractCheck {
    private EqualsTest equalsTest = EqualsTest.NEVER_FOR_NULLS;

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{109};
    }

    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 109) {
            this.visitQuestion(ast);
        }
    }

    private void visitQuestion(DetailAST ast) {
        DetailAST grandParent;
        DetailAST parent = ast.getParent();
        DetailAST detailAST = grandParent = parent != null ? parent.getParent() : parent;
        if (!(this.hasType(grandParent, 34) || this.isAllowedGrandParent(grandParent) || this.hasType(ast.getPreviousSibling(), 76) && this.hasType(ast.getNextSibling(), 77))) {
            this.log(ast.getLineNo(), ast.getColumnNo(), "ternary.missingParen", new Object[0]);
        }
        if (this.hasType(ast.getFirstChild(), 116) && !this.isEqualsTestAllowed(ast)) {
            this.log(ast.getLineNo(), ast.getColumnNo(), "ternary.equalOperator", new Object[0]);
        }
    }

    private boolean isAllowedGrandParent(DetailAST grandParent) {
        return this.hasType(grandParent, 17) || this.hasType(grandParent, 24) || this.hasType(grandParent, 83) || this.hasType(grandParent, 84);
    }

    private boolean isEqualsTestAllowed(DetailAST ast) {
        switch (this.equalsTest) {
            case ANY: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case NEVER_FOR_NULLS: {
                DetailAST equal = ast.findFirstToken(116);
                return equal.findFirstToken(135) == null;
            }
        }
        throw new IllegalStateException("Unsupported equals test " + (Object)((Object)this.equalsTest));
    }

    private boolean hasType(DetailAST ast, int type) {
        return ast != null && ast.getType() == type;
    }

    public void setEqualsTest(String equalsTest) {
        try {
            this.equalsTest = Enum.valueOf(EqualsTest.class, equalsTest.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("unable to parse " + equalsTest, ex);
        }
    }

    public static enum EqualsTest {
        ANY,
        NEVER,
        NEVER_FOR_NULLS;

    }
}

