/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.gradle.tasks;

import io.spring.javaformat.formatter.FileEdit;
import io.spring.javaformat.gradle.tasks.FormatterTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class CheckFormat
extends FormatterTask {
    public static final String NAME = "checkFormat";
    public static final String DESCRIPTION = "Run Spring Java formatting checks";
    private File reportLocation;

    @TaskAction
    public void checkFormatting() throws IOException, InterruptedException {
        List problems = this.formatFiles().filter(FileEdit::hasEdits).map(FileEdit::getFile).collect(Collectors.toList());
        this.reportLocation.getParentFile().mkdirs();
        if (!problems.isEmpty()) {
            StringBuilder message = new StringBuilder("Formatting violations found in the following files:\n");
            problems.stream().forEach(f -> message.append(" * " + this.getProject().relativePath(f) + "\n"));
            message.append("\nRun `format` to fix.");
            Files.write(this.reportLocation.toPath(), Collections.singletonList(message.toString()), StandardOpenOption.CREATE);
            throw new GradleException(message.toString());
        }
        this.reportLocation.createNewFile();
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @OutputFile
    public File getReportLocation() {
        return this.reportLocation;
    }

    public void setReportLocation(File reportLocation) {
        this.reportLocation = reportLocation;
    }
}

