/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.api.FileText;
import io.spring.nohttp.HttpMatchResult;
import io.spring.nohttp.HttpMatcher;
import io.spring.nohttp.RegexHttpMatcher;
import io.spring.nohttp.RegexPredicate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NoHttpCheck
extends AbstractFileSetCheck
implements ExternalResourceHolder {
    private HttpMatcher matcher;
    private String allowlistFileName = "";
    private String allowlist = "";

    public void setAllowlistFileName(String allowlistFileName) {
        if (allowlistFileName == null) {
            throw new IllegalArgumentException("allowlistFileName cannot be null");
        }
        this.allowlistFileName = allowlistFileName;
    }

    public void setAllowlist(String allowlist) {
        if (allowlist == null) {
            throw new IllegalArgumentException("allowlist cannot be null");
        }
        this.allowlist = allowlist;
    }

    @Deprecated
    public void setWhitelistFileName(String allowlistFileName) {
        this.setAllowlistFileName(allowlistFileName);
    }

    @Deprecated
    public void setWhitelist(String allowlist) {
        this.setWhitelistFileName(allowlist);
    }

    private boolean isAllowlistFileSet() {
        return !this.allowlistFileName.isEmpty();
    }

    private boolean isAllowlistSet() {
        return !this.allowlist.isEmpty();
    }

    private InputStream createAllowlistInputStream() {
        File allowlistFile = new File(this.allowlistFileName);
        try {
            return new FileInputStream(allowlistFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Could not load file '" + allowlistFile + "'", e);
        }
    }

    protected void finishLocalSetup() throws CheckstyleException {
        InputStream inputStream;
        RegexHttpMatcher matcher = new RegexHttpMatcher(RegexPredicate.createDefaultUrlAllowlist());
        if (this.isAllowlistFileSet()) {
            inputStream = this.createAllowlistInputStream();
            matcher.addHttpAllow(RegexPredicate.createAllowlistFromPatterns((InputStream)inputStream));
        }
        if (this.isAllowlistSet()) {
            inputStream = new ByteArrayInputStream(this.allowlist.getBytes());
            matcher.addHttpAllow(RegexPredicate.createAllowlistFromPatterns((InputStream)inputStream));
        }
        this.matcher = matcher;
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        int lineNum = 0;
        for (int index = 0; index < fileText.size(); ++index) {
            String line = fileText.get(index);
            ++lineNum;
            List results = this.matcher.findHttp(line);
            for (HttpMatchResult result : results) {
                this.log(lineNum, result.getStart() + 1, "nohttp", new Object[]{result.getHttp()});
            }
        }
    }

    public Set<String> getExternalResourceLocations() {
        HashSet<String> result = new HashSet<String>();
        if (this.isAllowlistFileSet()) {
            result.add(this.allowlistFileName);
        }
        return result;
    }
}

