/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp.gradle;

import io.spring.nohttp.gradle.NoHttpExtension;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.JavaExec;

public class NoHttpCliPlugin
implements Plugin<Project> {
    private Project project;
    private NoHttpExtension extension;

    public void apply(Project project) {
        this.project = project;
        this.extension = (NoHttpExtension)this.project.getExtensions().getByName("nohttp");
        Configuration nohttpCli = (Configuration)this.project.getConfigurations().create("nohttp-cli");
        this.configureDefaultDependenciesForProject(nohttpCli);
        JavaExec nohttp = (JavaExec)project.getTasks().create("nohttp", JavaExec.class);
        nohttp.setDescription("Runs nohttp");
        nohttp.setMain("io.spring.nohttp.cli.NoHttpCliMain");
        nohttp.setClasspath((FileCollection)nohttpCli);
    }

    private void configureDefaultDependenciesForProject(Configuration configuration) {
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                NoHttpExtension extension = NoHttpCliPlugin.this.extension;
                dependencies.add((Object)NoHttpCliPlugin.this.project.getDependencies().create((Object)("io.spring.nohttp:nohttp-cli:" + extension.getToolVersion())));
            }
        });
    }
}

