/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.remote;

import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.Response;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class PayloadRegistry {
    private static final Map<String, Class> REGISTRY_REQUEST = new HashMap<String, Class>();
    static boolean initialized = false;

    public static void init() {
        PayloadRegistry.scan();
    }

    private static synchronized void scan() {
        if (initialized) {
            return;
        }
        List<String> requestScanPackage = Arrays.asList("com.alibaba.nacos.api.naming.remote.request", "com.alibaba.nacos.api.config.remote.request", "com.alibaba.nacos.api.remote.request", "com.alibaba.nacos.naming.cluster.remote.request");
        for (String pkg : requestScanPackage) {
            Reflections reflections = new Reflections(pkg, new Scanner[0]);
            Set subTypesRequest = reflections.getSubTypesOf(Request.class);
            for (Class clazz : subTypesRequest) {
                PayloadRegistry.register(clazz.getSimpleName(), clazz);
            }
        }
        List<String> responseScanPackage = Arrays.asList("com.alibaba.nacos.api.naming.remote.response", "com.alibaba.nacos.api.config.remote.response", "com.alibaba.nacos.api.remote.response", "com.alibaba.nacos.naming.cluster.remote.response");
        for (String pkg : responseScanPackage) {
            Reflections reflections = new Reflections(pkg, new Scanner[0]);
            Set subTypesOfResponse = reflections.getSubTypesOf(Response.class);
            for (Class clazz : subTypesOfResponse) {
                PayloadRegistry.register(clazz.getSimpleName(), clazz);
            }
        }
        initialized = true;
    }

    static void register(String type, Class clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        if (Modifier.isInterface(clazz.getModifiers())) {
            return;
        }
        if (REGISTRY_REQUEST.containsKey(type)) {
            throw new RuntimeException(String.format("Fail to register, type:%s ,clazz:%s ", type, clazz.getName()));
        }
        REGISTRY_REQUEST.put(type, clazz);
    }

    public static Class getClassByType(String type) {
        return REGISTRY_REQUEST.get(type);
    }
}

