/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.spi.client;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.plugin.auth.spi.client.AbstractClientAuthService;
import com.alibaba.nacos.plugin.auth.spi.client.ClientAuthService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthPluginManager
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientAuthPluginManager.class);
    private final Set<ClientAuthService> clientAuthServiceHashSet = new HashSet<ClientAuthService>();

    public void init(List<String> serverList, NacosRestTemplate nacosRestTemplate) {
        Collection clientAuthServices = NacosServiceLoader.load(AbstractClientAuthService.class);
        for (ClientAuthService clientAuthService : clientAuthServices) {
            clientAuthService.setServerList(serverList);
            clientAuthService.setNacosRestTemplate(nacosRestTemplate);
            this.clientAuthServiceHashSet.add(clientAuthService);
            LOGGER.info("[ClientAuthPluginManager] Load ClientAuthService {} success.", (Object)clientAuthService.getClass().getCanonicalName());
        }
        if (this.clientAuthServiceHashSet.isEmpty()) {
            LOGGER.warn("[ClientAuthPluginManager] Load ClientAuthService fail, No ClientAuthService implements");
        }
    }

    public Set<ClientAuthService> getAuthServiceSpiImplSet() {
        return this.clientAuthServiceHashSet;
    }

    public void shutdown() throws NacosException {
        for (ClientAuthService each : this.clientAuthServiceHashSet) {
            each.shutdown();
        }
    }
}

