/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.common.remote.client.grpc.GrpcClientConfig;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class DefaultGrpcClientConfig
implements GrpcClientConfig {
    private String name;
    private int retryTimes;
    private long timeOutMills;
    private long connectionKeepAlive;
    private long threadPoolKeepAlive;
    private int threadPoolCoreSize;
    private int threadPoolMaxSize;
    private long serverCheckTimeOut;
    private int threadPoolQueueSize;
    private int maxInboundMessageSize;
    private int channelKeepAlive;
    private int healthCheckRetryTimes;
    private long healthCheckTimeOut;
    private Map<String, String> labels;

    private DefaultGrpcClientConfig(Builder builder) {
        this.name = builder.name;
        this.retryTimes = this.loadIntegerConfig("nacos.remote.client.grpc.retry.times", builder.retryTimes);
        this.timeOutMills = this.loadLongConfig("nacos.remote.client.grpc.timeout", builder.timeOutMills);
        this.connectionKeepAlive = this.loadLongConfig("nacos.remote.client.grpc.connect.keep.alive", builder.connectionKeepAlive);
        this.threadPoolKeepAlive = this.loadLongConfig("nacos.remote.client.grpc.pool.alive", builder.threadPoolKeepAlive);
        this.threadPoolCoreSize = this.loadIntegerConfig("nacos.remote.client.grpc.pool.core.size", builder.threadPoolCoreSize);
        this.threadPoolMaxSize = this.loadIntegerConfig("nacos.remote.client.grpc.pool.max.size", builder.threadPoolMaxSize);
        this.serverCheckTimeOut = this.loadLongConfig("nacos.remote.client.grpc.server.check.timeout", builder.serverCheckTimeOut);
        this.threadPoolQueueSize = this.loadIntegerConfig("nacos.remote.client.grpc.queue.size", builder.threadPoolQueueSize);
        this.maxInboundMessageSize = this.loadIntegerConfig("nacos.remote.client.grpc.maxinbound.message.size", builder.maxInboundMessageSize);
        this.channelKeepAlive = this.loadIntegerConfig("nacos.remote.client.grpc.channel.keep.alive", builder.channelKeepAlive);
        this.healthCheckRetryTimes = this.loadIntegerConfig("nacos.remote.client.grpc.health.retry", builder.healthCheckRetryTimes);
        this.healthCheckTimeOut = this.loadLongConfig("nacos.remote.client.grpc.health.timeout", builder.healthCheckTimeOut);
        this.labels = builder.labels;
    }

    private int loadIntegerConfig(String key, int builderValue) {
        return Integer.getInteger(key, builderValue);
    }

    private long loadLongConfig(String key, long builderValue) {
        return Long.getLong(key, builderValue);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int retryTimes() {
        return this.retryTimes;
    }

    @Override
    public long timeOutMills() {
        return this.timeOutMills;
    }

    @Override
    public long connectionKeepAlive() {
        return this.connectionKeepAlive;
    }

    @Override
    public int threadPoolCoreSize() {
        return this.threadPoolCoreSize;
    }

    @Override
    public int threadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public long threadPoolKeepAlive() {
        return this.threadPoolKeepAlive;
    }

    @Override
    public long serverCheckTimeOut() {
        return this.serverCheckTimeOut;
    }

    @Override
    public int threadPoolQueueSize() {
        return this.threadPoolQueueSize;
    }

    @Override
    public int maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    @Override
    public int channelKeepAlive() {
        return this.channelKeepAlive;
    }

    @Override
    public int healthCheckRetryTimes() {
        return this.healthCheckRetryTimes;
    }

    @Override
    public long healthCheckTimeOut() {
        return this.healthCheckTimeOut;
    }

    @Override
    public Map<String, String> labels() {
        return this.labels;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private int retryTimes = 3;
        private long timeOutMills = 3000L;
        private long connectionKeepAlive = 5000L;
        private long threadPoolKeepAlive = 10000L;
        private int threadPoolCoreSize = ThreadUtils.getSuitableThreadCount(2);
        private int threadPoolMaxSize = ThreadUtils.getSuitableThreadCount(8);
        private long serverCheckTimeOut = 3000L;
        private int threadPoolQueueSize = 10000;
        private int maxInboundMessageSize = 0xA00000;
        private int channelKeepAlive = 360000;
        private int healthCheckRetryTimes = 3;
        private long healthCheckTimeOut = 3000L;
        private Map<String, String> labels = new HashMap<String, String>();

        private Builder() {
        }

        public Builder fromProperties(Properties properties) {
            if (properties.contains("nacos.remote.client.grpc.name")) {
                this.name = properties.getProperty("nacos.remote.client.grpc.name");
            }
            if (properties.contains("nacos.remote.client.grpc.retry.times")) {
                this.retryTimes = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.retry.times"));
            }
            if (properties.contains("nacos.remote.client.grpc.timeout")) {
                this.timeOutMills = Long.parseLong(properties.getProperty("nacos.remote.client.grpc.timeout"));
            }
            if (properties.contains("nacos.remote.client.grpc.connect.keep.alive")) {
                this.connectionKeepAlive = Long.parseLong(properties.getProperty("nacos.remote.client.grpc.connect.keep.alive"));
            }
            if (properties.contains("nacos.remote.client.grpc.pool.alive")) {
                this.threadPoolKeepAlive = Long.parseLong(properties.getProperty("nacos.remote.client.grpc.pool.alive"));
            }
            if (properties.contains("nacos.remote.client.grpc.pool.core.size")) {
                this.threadPoolCoreSize = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.pool.core.size"));
            }
            if (properties.contains("nacos.remote.client.grpc.pool.max.size")) {
                this.threadPoolMaxSize = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.pool.max.size"));
            }
            if (properties.contains("nacos.remote.client.grpc.server.check.timeout")) {
                this.serverCheckTimeOut = Long.parseLong(properties.getProperty("nacos.remote.client.grpc.server.check.timeout"));
            }
            if (properties.contains("nacos.remote.client.grpc.queue.size")) {
                this.threadPoolQueueSize = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.queue.size"));
            }
            if (properties.contains("nacos.remote.client.grpc.maxinbound.message.size")) {
                this.maxInboundMessageSize = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.maxinbound.message.size"));
            }
            if (properties.contains("nacos.remote.client.grpc.channel.keep.alive")) {
                this.channelKeepAlive = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.channel.keep.alive"));
            }
            if (properties.contains("nacos.remote.client.grpc.health.retry")) {
                this.healthCheckRetryTimes = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.health.retry"));
            }
            if (properties.contains("nacos.remote.client.grpc.health.timeout")) {
                this.healthCheckTimeOut = Long.parseLong(properties.getProperty("nacos.remote.client.grpc.health.timeout"));
            }
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setRetryTimes(int retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public Builder setTimeOutMills(long timeOutMills) {
            this.timeOutMills = timeOutMills;
            return this;
        }

        public Builder setConnectionKeepAlive(long connectionKeepAlive) {
            this.connectionKeepAlive = connectionKeepAlive;
            return this;
        }

        public Builder setThreadPoolKeepAlive(Long threadPoolKeepAlive) {
            this.threadPoolKeepAlive = threadPoolKeepAlive;
            return this;
        }

        public Builder setThreadPoolCoreSize(Integer threadPoolCoreSize) {
            if (!Objects.isNull(threadPoolCoreSize)) {
                this.threadPoolCoreSize = threadPoolCoreSize;
            }
            return this;
        }

        public Builder setThreadPoolMaxSize(Integer threadPoolMaxSize) {
            if (!Objects.isNull(threadPoolMaxSize)) {
                this.threadPoolMaxSize = threadPoolMaxSize;
            }
            return this;
        }

        public Builder setServerCheckTimeOut(Long serverCheckTimeOut) {
            this.serverCheckTimeOut = serverCheckTimeOut;
            return this;
        }

        public Builder setThreadPoolQueueSize(int threadPoolQueueSize) {
            this.threadPoolQueueSize = threadPoolQueueSize;
            return this;
        }

        public Builder setMaxInboundMessageSize(int maxInboundMessageSize) {
            this.maxInboundMessageSize = maxInboundMessageSize;
            return this;
        }

        public Builder setChannelKeepAlive(int channelKeepAlive) {
            this.channelKeepAlive = channelKeepAlive;
            return this;
        }

        public Builder setHealthCheckRetryTimes(int healthCheckRetryTimes) {
            this.healthCheckRetryTimes = healthCheckRetryTimes;
            return this;
        }

        public Builder setHealthCheckTimeOut(long healthCheckTimeOut) {
            this.healthCheckTimeOut = healthCheckTimeOut;
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels.putAll(labels);
            return this;
        }

        public GrpcClientConfig build() {
            return new DefaultGrpcClientConfig(this);
        }
    }
}

