/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import java.util.List;
import java.util.Objects;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/history"})
public class HistoryController {
    private final PersistService persistService;

    public HistoryController(PersistService persistService) {
        this.persistService = persistService;
    }

    @GetMapping(params={"search=accurate"})
    @Secured(action=ActionTypes.READ, signType="config")
    public Page<ConfigHistoryInfo> listConfigHistory(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="pageNo", required=false) Integer pageNo, @RequestParam(value="pageSize", required=false) Integer pageSize, ModelMap modelMap) {
        pageNo = null == pageNo ? 1 : pageNo;
        pageSize = null == pageSize ? 100 : pageSize;
        pageSize = Math.min(500, pageSize);
        return this.persistService.findConfigHistory(dataId, group, tenant, pageNo, pageSize);
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, signType="config")
    public ConfigHistoryInfo getConfigHistoryInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="nid") Long nid) throws AccessException {
        ConfigHistoryInfo configHistoryInfo = this.persistService.detailConfigHistory(nid);
        if (Objects.isNull(configHistoryInfo)) {
            return null;
        }
        this.checkHistoryInfoPermission(configHistoryInfo, dataId, group, tenant);
        String encryptedDataKey = configHistoryInfo.getEncryptedDataKey();
        Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)configHistoryInfo.getContent());
        configHistoryInfo.setContent((String)pair.getSecond());
        return configHistoryInfo;
    }

    private void checkHistoryInfoPermission(ConfigHistoryInfo configHistoryInfo, String dataId, String group, String tenant) throws AccessException {
        if (!(Objects.equals(configHistoryInfo.getDataId(), dataId) && Objects.equals(configHistoryInfo.getGroup(), group) && Objects.equals(configHistoryInfo.getTenant(), tenant))) {
            throw new AccessException("Please check dataId, group or tenant.");
        }
    }

    @GetMapping(value={"/previous"})
    @Secured(action=ActionTypes.READ, signType="config")
    public ConfigHistoryInfo getPreviousConfigHistoryInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="id") Long id) throws AccessException {
        ConfigHistoryInfo configHistoryInfo = this.persistService.detailPreviousConfigHistory(id);
        if (Objects.isNull(configHistoryInfo)) {
            return null;
        }
        this.checkHistoryInfoPermission(configHistoryInfo, dataId, group, tenant);
        return configHistoryInfo;
    }

    @GetMapping(value={"/configs"})
    @Secured(action=ActionTypes.READ, signType="config")
    public List<ConfigInfoWrapper> getDataIds(@RequestParam(value="tenant") String tenant) {
        ParamUtils.checkTenant(tenant);
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        return this.persistService.queryConfigInfoByNamespace(tenant);
    }
}

