/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump.processor;

import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import java.sql.Timestamp;
import java.util.List;

public class DumpChangeProcessor
implements NacosTaskProcessor {
    final DumpService dumpService;
    final PersistService persistService;
    final Timestamp startTime;
    final Timestamp endTime;

    public DumpChangeProcessor(DumpService dumpService, Timestamp startTime, Timestamp endTime) {
        this.dumpService = dumpService;
        this.persistService = dumpService.getPersistService();
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public boolean process(NacosTask task) {
        LogUtil.DEFAULT_LOG.warn("quick start; startTime:{},endTime:{}", (Object)this.startTime, (Object)this.endTime);
        LogUtil.DEFAULT_LOG.warn("updateMd5 start");
        long startUpdateMd5 = System.currentTimeMillis();
        List<ConfigInfoWrapper> updateMd5List = this.persistService.listAllGroupKeyMd5();
        LogUtil.DEFAULT_LOG.warn("updateMd5 count:{}", (Object)updateMd5List.size());
        for (ConfigInfoWrapper config : updateMd5List) {
            String groupKey = GroupKey2.getKey(config.getDataId(), config.getGroup());
            ConfigCacheService.updateMd5(groupKey, config.getMd5(), config.getLastModified(), config.getEncryptedDataKey());
        }
        long endUpdateMd5 = System.currentTimeMillis();
        LogUtil.DEFAULT_LOG.warn("updateMd5 done,cost:{}", (Object)(endUpdateMd5 - startUpdateMd5));
        LogUtil.DEFAULT_LOG.warn("deletedConfig start");
        long startDeletedConfigTime = System.currentTimeMillis();
        List<ConfigInfo> configDeleted = this.persistService.findDeletedConfig(this.startTime, this.endTime);
        LogUtil.DEFAULT_LOG.warn("deletedConfig count:{}", (Object)configDeleted.size());
        for (ConfigInfo configInfo : configDeleted) {
            if (this.persistService.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()) != null) continue;
            ConfigCacheService.remove(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
        }
        long endDeletedConfigTime = System.currentTimeMillis();
        LogUtil.DEFAULT_LOG.warn("deletedConfig done,cost:{}", (Object)(endDeletedConfigTime - startDeletedConfigTime));
        LogUtil.DEFAULT_LOG.warn("changeConfig start");
        long startChangeConfigTime = System.currentTimeMillis();
        List<ConfigInfoWrapper> changeConfigs = this.persistService.findChangeConfig(this.startTime, this.endTime);
        LogUtil.DEFAULT_LOG.warn("changeConfig count:{}", (Object)changeConfigs.size());
        for (ConfigInfoWrapper cf : changeConfigs) {
            ConfigCacheService.dumpChange(cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getContent(), cf.getLastModified(), cf.getEncryptedDataKey());
            String content = cf.getContent();
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            LogUtil.DEFAULT_LOG.info("[dump-change-ok] {}, {}, length={}, md5={}", new Object[]{GroupKey2.getKey(cf.getDataId(), cf.getGroup()), cf.getLastModified(), content.length(), md5});
        }
        ConfigCacheService.reloadConfig();
        long endChangeConfigTime = System.currentTimeMillis();
        LogUtil.DEFAULT_LOG.warn("changeConfig done,cost:{}", (Object)(endChangeConfigTime - startChangeConfigTime));
        return true;
    }
}

