/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.enums.FileTypeEnum;
import com.alibaba.nacos.config.server.model.CacheItem;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.LongPollingService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.DiskUtil;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.MD5Util;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.Protocol;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigServletInner {
    private static final int TRY_GET_LOCK_TIMES = 9;
    private static final int START_LONG_POLLING_VERSION_NUM = 204;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigServletInner.class);
    private final LongPollingService longPollingService;
    private ConfigInfoPersistService configInfoPersistService;
    private ConfigInfoBetaPersistService configInfoBetaPersistService;
    private ConfigInfoTagPersistService configInfoTagPersistService;

    public ConfigServletInner(LongPollingService longPollingService, ConfigInfoPersistService configInfoPersistService, ConfigInfoBetaPersistService configInfoBetaPersistService, ConfigInfoTagPersistService configInfoTagPersistService) {
        this.longPollingService = longPollingService;
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoBetaPersistService = configInfoBetaPersistService;
        this.configInfoTagPersistService = configInfoTagPersistService;
    }

    public String doPollingConfig(HttpServletRequest request, HttpServletResponse response, Map<String, String> clientMd5Map, int probeRequestSize) throws IOException {
        int versionNum;
        if (LongPollingService.isSupportLongPolling(request)) {
            this.longPollingService.addLongPollingClient(request, response, clientMd5Map, probeRequestSize);
            return "200";
        }
        List<String> changedGroups = MD5Util.compareMd5(request, response, clientMd5Map);
        String oldResult = MD5Util.compareMd5OldResult(changedGroups);
        String newResult = MD5Util.compareMd5ResultString(changedGroups);
        String version = request.getHeader("Client-Version");
        if (version == null) {
            version = "2.0.0";
        }
        if ((versionNum = Protocol.getVersionNumber(version)) < 204) {
            response.addHeader("Probe-Modify-Response", oldResult);
            response.addHeader("Probe-Modify-Response-New", newResult);
        } else {
            request.setAttribute("content", (Object)newResult);
        }
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-cache,no-store");
        response.setStatus(200);
        return "200";
    }

    public String doGetConfig(HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String tag, String isNotify, String clientIp) throws IOException, ServletException {
        return this.doGetConfig(request, response, dataId, group, tenant, tag, isNotify, clientIp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String doGetConfig(HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String tag, String isNotify, String clientIp, boolean isV2) throws IOException, ServletException {
        block34: {
            block33: {
                block31: {
                    block32: {
                        notify = false;
                        if (StringUtils.isNotBlank((String)isNotify)) {
                            notify = Boolean.parseBoolean(isNotify);
                        }
                        if (isV2) {
                            response.setHeader("Content-Type", "application/json;charset=UTF-8");
                        }
                        groupKey = GroupKey2.getKey(dataId, group, tenant);
                        autoTag = request.getHeader("Vipserver-Tag");
                        requestIpApp = RequestUtil.getAppName(request);
                        lockResult = ConfigServletInner.tryConfigReadLock(groupKey);
                        requestIp = RequestUtil.getRemoteIp(request);
                        isBeta = false;
                        isSli = false;
                        if (lockResult <= 0) break block33;
                        fis = null;
                        try {
                            md5 = "";
                            lastModified = 0L;
                            cacheItem = ConfigCacheService.getContentCache(groupKey);
                            if (cacheItem.isBeta() && cacheItem.getIps4Beta().contains(clientIp)) {
                                isBeta = true;
                            }
                            configType = null != cacheItem.getType() ? cacheItem.getType() : FileTypeEnum.TEXT.getFileType();
                            response.setHeader("Config-Type", configType);
                            fileTypeEnum = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(configType);
                            contentTypeHeader = fileTypeEnum.getContentType();
                            response.setHeader("Content-Type", contentTypeHeader);
                            if (isV2) {
                                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                            }
                            file = null;
                            configInfoBase = null;
                            if (isBeta) {
                                md5 = cacheItem.getMd54Beta();
                                lastModified = cacheItem.getLastModifiedTs4Beta();
                                if (PropertyUtil.isDirectRead()) {
                                    configInfoBase = this.configInfoBetaPersistService.findConfigInfo4Beta(dataId, group, tenant);
                                } else {
                                    file = DiskUtil.targetBetaFile(dataId, group, tenant);
                                }
                                response.setHeader("isBeta", "true");
                                break block31;
                            }
                            if (!StringUtils.isBlank((CharSequence)tag)) ** GOTO lbl71
                            if (ConfigServletInner.isUseTag(cacheItem, autoTag)) {
                                if (cacheItem.tagMd5 != null) {
                                    md5 = cacheItem.tagMd5.get(autoTag);
                                }
                                if (cacheItem.tagLastModifiedTs != null) {
                                    lastModified = cacheItem.tagLastModifiedTs.get(autoTag);
                                }
                                if (PropertyUtil.isDirectRead()) {
                                    configInfoBase = this.configInfoTagPersistService.findConfigInfo4Tag(dataId, group, tenant, autoTag);
                                } else {
                                    file = DiskUtil.targetTagFile(dataId, group, tenant, autoTag);
                                }
                                response.setHeader("Vipserver-Tag", URLEncoder.encode(autoTag, StandardCharsets.UTF_8.displayName()));
                                break block31;
                            }
                            md5 = cacheItem.getMd5();
                            lastModified = cacheItem.getLastModifiedTs();
                            if (PropertyUtil.isDirectRead()) {
                                configInfoBase = this.configInfoPersistService.findConfigInfo(dataId, group, tenant);
                            } else {
                                file = DiskUtil.targetFile(dataId, group, tenant);
                            }
                            if (configInfoBase != null || !ConfigServletInner.fileNotExist(file)) break block32;
                            ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "not-found", -1L, requestIp, notify);
                            var29_27 = this.get404Result(response, isV2);
                        }
                        catch (Throwable var33_35) {
                            ConfigServletInner.releaseConfigReadLock(groupKey);
                            IoUtils.closeQuietly(fis);
                            throw var33_35;
                        }
                        ConfigServletInner.releaseConfigReadLock(groupKey);
                        IoUtils.closeQuietly((Closeable)fis);
                        return var29_27;
                    }
                    isSli = true;
                    break block31;
lbl71:
                    // 1 sources

                    if (cacheItem.tagMd5 != null) {
                        md5 = cacheItem.tagMd5.get(tag);
                    }
                    if (cacheItem.tagLastModifiedTs != null && (lm = cacheItem.tagLastModifiedTs.get(tag)) != null) {
                        lastModified = lm.longValue();
                    }
                    if (PropertyUtil.isDirectRead()) {
                        configInfoBase = this.configInfoTagPersistService.findConfigInfo4Tag(dataId, group, tenant, tag);
                    } else {
                        file = DiskUtil.targetTagFile(dataId, group, tenant, tag);
                    }
                    if (configInfoBase != null || !ConfigServletInner.fileNotExist(file)) break block31;
                    ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "not-found", -1L, requestIp, notify != false && isSli != false);
                    lm = this.get404Result(response, isV2);
                    ConfigServletInner.releaseConfigReadLock(groupKey);
                    IoUtils.closeQuietly((Closeable)fis);
                    return lm;
                }
                response.setHeader("Content-MD5", md5);
                response.setHeader("Pragma", "no-cache");
                response.setDateHeader("Expires", 0L);
                response.setHeader("Cache-Control", "no-cache,no-store");
                if (PropertyUtil.isDirectRead()) {
                    response.setDateHeader("Last-Modified", lastModified);
                } else {
                    fis = new FileInputStream(file);
                    response.setDateHeader("Last-Modified", file.lastModified());
                }
                if (PropertyUtil.isDirectRead()) {
                    pair = EncryptionHandler.decryptHandler((String)dataId, (String)configInfoBase.getEncryptedDataKey(), (String)configInfoBase.getContent());
                    out = response.getWriter();
                    if (isV2) {
                        out.print(JacksonUtils.toJson((Object)Result.success((Object)((String)pair.getSecond()))));
                    } else {
                        out.print((String)pair.getSecond());
                    }
                    out.flush();
                    out.close();
                } else {
                    fileContent = IoUtils.toString((InputStream)fis, (String)StandardCharsets.UTF_8.name());
                    encryptedDataKey = cacheItem.getEncryptedDataKey();
                    pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)fileContent);
                    decryptContent = (String)pair.getSecond();
                    out = response.getWriter();
                    if (isV2) {
                        out.print(JacksonUtils.toJson((Object)Result.success((Object)decryptContent)));
                    } else {
                        out.print(decryptContent);
                    }
                    out.flush();
                    out.close();
                }
                LogUtil.PULL_CHECK_LOG.warn("{}|{}|{}|{}", new Object[]{groupKey, requestIp, md5, TimeUtils.getCurrentTimeStr()});
                delayed = System.currentTimeMillis() - lastModified;
                ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, lastModified, "ok", delayed, requestIp, notify != false && isSli != false);
                break block34;
            }
            if (lockResult == 0) {
                ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "not-found", -1L, requestIp, notify != false && isSli != false);
                return this.get404Result(response, isV2);
            }
            LogUtil.PULL_LOG.info("[client-get] clientIp={}, {}, get data during dump", (Object)clientIp, (Object)groupKey);
            return this.get409Result(response, isV2);
        }
        ConfigServletInner.releaseConfigReadLock(groupKey);
        IoUtils.closeQuietly((Closeable)fis);
        return "200";
    }

    private static void releaseConfigReadLock(String groupKey) {
        ConfigCacheService.releaseReadLock(groupKey);
    }

    private String get404Result(HttpServletResponse response, boolean isV2) throws IOException {
        response.setStatus(404);
        PrintWriter writer = response.getWriter();
        if (isV2) {
            writer.println(JacksonUtils.toJson((Object)Result.failure((ErrorCode)ErrorCode.RESOURCE_NOT_FOUND, (Object)"config data not exist")));
        } else {
            writer.println("config data not exist");
        }
        return "404";
    }

    private String get409Result(HttpServletResponse response, boolean isV2) throws IOException {
        response.setStatus(409);
        PrintWriter writer = response.getWriter();
        if (isV2) {
            writer.println(JacksonUtils.toJson((Object)Result.failure((ErrorCode)ErrorCode.RESOURCE_CONFLICT, (Object)"requested file is being modified, please try later.")));
        } else {
            writer.println("requested file is being modified, please try later.");
        }
        return "409";
    }

    private static int tryConfigReadLock(String groupKey) {
        int lockResult = -1;
        for (int i = 9; i >= 0 && 0 != (lockResult = ConfigCacheService.tryReadLock(groupKey)) && lockResult <= 0; --i) {
            if (i <= 0) continue;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e) {
                LogUtil.PULL_CHECK_LOG.error("An Exception occurred while thread sleep", (Throwable)e);
            }
        }
        return lockResult;
    }

    private static boolean isUseTag(CacheItem cacheItem, String tag) {
        if (cacheItem != null && cacheItem.tagMd5 != null && cacheItem.tagMd5.size() > 0) {
            return StringUtils.isNotBlank((String)tag) && cacheItem.tagMd5.containsKey(tag);
        }
        return false;
    }

    private static boolean fileNotExist(File file) {
        return file == null || !file.exists();
    }
}

