/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.controller.ConfigServletInner;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v2/cs/config"})
public class ConfigControllerV2 {
    private final ConfigServletInner inner;
    private final ConfigOperationService configOperationService;

    public ConfigControllerV2(ConfigServletInner inner, ConfigOperationService configOperationService) {
        this.inner = inner;
        this.configOperationService = configOperationService;
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, signType="config")
    public void getConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="namespaceId", required=false, defaultValue="") String namespaceId, @RequestParam(value="tag", required=false) String tag) throws NacosException, IOException, ServletException {
        ParamUtils.checkTenantV2(namespaceId);
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        ParamUtils.checkParamV2(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        String isNotify = request.getHeader("notify");
        this.inner.doGetConfig(request, response, dataId, group, namespaceId, tag, isNotify, clientIp, true);
    }

    @PostMapping
    @Secured(action=ActionTypes.WRITE, signType="config")
    public Result<Boolean> publishConfig(ConfigForm configForm, HttpServletRequest request) throws NacosException {
        configForm.validate();
        Pair pair = EncryptionHandler.encryptHandler((String)configForm.getDataId(), (String)configForm.getContent());
        configForm.setContent((String)pair.getSecond());
        ParamUtils.checkTenantV2(configForm.getNamespaceId());
        ParamUtils.checkParam(configForm.getDataId(), configForm.getGroup(), "datumId", configForm.getContent());
        ParamUtils.checkParamV2(configForm.getTag());
        if (StringUtils.isBlank((CharSequence)configForm.getSrcUser())) {
            configForm.setSrcUser(RequestUtil.getSrcUserName(request));
        }
        if (!ConfigType.isValidType((String)configForm.getType()).booleanValue()) {
            configForm.setType(ConfigType.getDefaultType().getType());
        }
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        configRequestInfo.setSrcIp(RequestUtil.getRemoteIp(request));
        configRequestInfo.setRequestIpApp(RequestUtil.getAppName(request));
        configRequestInfo.setBetaIps(request.getHeader("betaIps"));
        String encryptedDataKey = (String)pair.getFirst();
        return Result.success((Object)this.configOperationService.publishConfig(configForm, configRequestInfo, encryptedDataKey));
    }

    @DeleteMapping
    @Secured(action=ActionTypes.WRITE, signType="config")
    public Result<Boolean> deleteConfig(HttpServletRequest request, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="namespaceId", required=false, defaultValue="") String namespaceId, @RequestParam(value="tag", required=false) String tag) throws NacosException {
        ParamUtils.checkTenantV2(namespaceId);
        ParamUtils.checkParam(dataId, group, "datumId", "rm");
        ParamUtils.checkParamV2(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        String srcUser = RequestUtil.getSrcUserName(request);
        return Result.success((Object)this.configOperationService.deleteConfig(dataId, group, namespaceId, tag, clientIp, srcUser));
    }
}

