/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.model;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.PrintWriter;
import java.io.Serializable;

public class ConfigInfoBase
implements Serializable,
Comparable<ConfigInfoBase> {
    static final long serialVersionUID = 265316491795790798L;
    @JsonSerialize(using=ToStringSerializer.class)
    private long id;
    private String dataId;
    private String group;
    private String content;
    private String md5;
    private String encryptedDataKey;

    public ConfigInfoBase() {
    }

    public ConfigInfoBase(String dataId, String group, String content) {
        this.dataId = dataId;
        this.group = group;
        this.content = content;
        if (this.content != null) {
            this.md5 = MD5Utils.md5Hex((String)this.content, (String)"UTF-8");
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void dump(PrintWriter writer) {
        writer.write(this.content);
    }

    public String getEncryptedDataKey() {
        return this.encryptedDataKey;
    }

    public void setEncryptedDataKey(String encryptedDataKey) {
        this.encryptedDataKey = encryptedDataKey;
    }

    @Override
    public int compareTo(ConfigInfoBase o) {
        if (o == null) {
            return 1;
        }
        if (this.dataId == null) {
            if (o.getDataId() == null) {
                return 0;
            }
            return -1;
        }
        if (o.getDataId() == null) {
            return 1;
        }
        int cmpDataId = this.dataId.compareTo(o.getDataId());
        if (cmpDataId != 0) {
            return cmpDataId;
        }
        if (this.group == null) {
            if (o.getGroup() == null) {
                return 0;
            }
            return -1;
        }
        if (o.getGroup() == null) {
            return 1;
        }
        int cmpGroup = this.group.compareTo(o.getGroup());
        if (cmpGroup != 0) {
            return cmpGroup;
        }
        if (this.content == null) {
            if (o.getContent() == null) {
                return 0;
            }
            return -1;
        }
        if (o.getContent() == null) {
            return 1;
        }
        int cmpContent = this.content.compareTo(o.getContent());
        if (cmpContent != 0) {
            return cmpContent;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.md5 == null ? 0 : this.md5.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigInfoBase other = (ConfigInfoBase)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.dataId == null ? other.dataId != null : !this.dataId.equals(other.dataId)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        return !(this.md5 == null ? other.md5 != null : !this.md5.equals(other.md5));
    }

    public String toString() {
        return "ConfigInfoBase{id=" + this.id + ", dataId='" + this.dataId + '\'' + ", group='" + this.group + '\'' + ", content='" + this.content + '\'' + ", md5='" + this.md5 + '\'' + '}';
    }
}

