/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.model.TenantInfo;
import com.alibaba.nacos.config.server.model.event.DerbyImportEvent;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.CommonPersistService;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.TenantInfoMapper;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedOtherPersistServiceImpl")
public class EmbeddedCommonPersistServiceImpl
implements CommonPersistService {
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private MapperManager mapperManager;

    public EmbeddedCommonPersistServiceImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTenantInfoAtomic(String kp, String tenantId, String tenantName, String tenantDesc, String createResoure, long time) {
        TenantInfoMapper tenantInfoMapper = (TenantInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_info");
        String sql = tenantInfoMapper.insert(Arrays.asList("kp", "tenant_id", "tenant_name", "tenant_desc", "create_source", "gmt_create", "gmt_modified"));
        Object[] args = new Object[]{kp, tenantId, tenantName, tenantDesc, createResoure, time, time};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("Namespace creation failed");
            }
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTenantInfoAtomic(String kp, String tenantId) {
        TenantInfoMapper tenantInfoMapper = (TenantInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_info");
        EmbeddedStorageContextUtils.addSqlContext(tenantInfoMapper.delete(Arrays.asList("kp", "tenant_id")), kp, tenantId);
        try {
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTenantNameAtomic(String kp, String tenantId, String tenantName, String tenantDesc) {
        TenantInfoMapper tenantInfoMapper = (TenantInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_info");
        String sql = tenantInfoMapper.update(Arrays.asList("tenant_name", "tenant_desc", "gmt_modified"), Arrays.asList("kp", "tenant_id"));
        Object[] args = new Object[]{tenantName, tenantDesc, System.currentTimeMillis(), kp, tenantId};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("Namespace update failed");
            }
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public List<TenantInfo> findTenantByKp(String kp) {
        TenantInfoMapper tenantInfoMapper = (TenantInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_info");
        String sql = tenantInfoMapper.select(Arrays.asList("tenant_id", "tenant_name", "tenant_desc"), Collections.singletonList("kp"));
        return this.databaseOperate.queryMany(sql, new Object[]{kp}, RowMapperManager.TENANT_INFO_ROW_MAPPER);
    }

    @Override
    public TenantInfo findTenantByKp(String kp, String tenantId) {
        TenantInfoMapper tenantInfoMapper = (TenantInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_info");
        String sql = tenantInfoMapper.select(Arrays.asList("tenant_id", "tenant_name", "tenant_desc"), Arrays.asList("kp", "tenant_id"));
        return this.databaseOperate.queryOne(sql, new Object[]{kp, tenantId}, RowMapperManager.TENANT_INFO_ROW_MAPPER);
    }

    @Override
    public String generateLikeArgument(String s) {
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains("*")) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public boolean isExistTable(String tableName) {
        String sql = String.format("SELECT 1 FROM %s FETCH FIRST ROW ONLY", tableName);
        try {
            this.databaseOperate.queryOne(sql, Integer.class);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public int tenantInfoCountByTenantId(String tenantId) {
        if (Objects.isNull(tenantId)) {
            throw new IllegalArgumentException("tenantId can not be null");
        }
        TenantInfoMapper tenantInfoMapper = (TenantInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_info");
        String sql = tenantInfoMapper.count(Arrays.asList("tenant_id"));
        Integer result = this.databaseOperate.queryOne(sql, (Object[])new String[]{tenantId}, Integer.class);
        if (result == null) {
            return 0;
        }
        return result;
    }
}

