/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.model.ConfigKey;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.event.DerbyImportEvent;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoAggrPersistService;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoAggrMapper;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedConfigInfoAggrPersistServiceImpl")
public class EmbeddedConfigInfoAggrPersistServiceImpl
implements ConfigInfoAggrPersistService {
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private MapperManager mapperManager;

    public EmbeddedConfigInfoAggrPersistServiceImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    @Override
    public String generateLikeArgument(String s) {
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains("*")) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAggrConfigInfo(String dataId, String group, String tenant, String datumId, String appName, String content) {
        Object[] args;
        String appNameTmp = StringUtils.isBlank((CharSequence)appName) ? "" : appName;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String contentTmp = StringUtils.isBlank((CharSequence)content) ? "" : content;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String select = configInfoAggrMapper.select(Collections.singletonList("content"), Arrays.asList("data_id", "group_id", "tenant_id", "datum_id"));
        String insert = configInfoAggrMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "datum_id", "app_name", "content", "gmt_modified"));
        String update = configInfoAggrMapper.update(Arrays.asList("content", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id", "datum_id"));
        String dbContent = this.databaseOperate.queryOne(select, new Object[]{dataId, group, tenantTmp, datumId}, String.class);
        if (Objects.isNull(dbContent)) {
            args = new Object[]{dataId, group, tenantTmp, datumId, appNameTmp, contentTmp, now};
            EmbeddedStorageContextUtils.addSqlContext(insert, args);
        } else if (!dbContent.equals(content)) {
            args = new Object[]{contentTmp, now, dataId, group, tenantTmp, datumId};
            EmbeddedStorageContextUtils.addSqlContext(update, args);
        }
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("[Merge] Configuration release failed");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean batchPublishAggr(String dataId, String group, String tenant, Map<String, String> datumMap, String appName) {
        try {
            Boolean isPublishOk = false;
            for (Map.Entry<String, String> entry : datumMap.entrySet()) {
                this.addAggrConfigInfo(dataId, group, tenant, entry.getKey(), appName, entry.getValue());
            }
            isPublishOk = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (isPublishOk == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = isPublishOk;
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceAggr(String dataId, String group, String tenant, Map<String, String> datumMap, String appName) {
        Boolean isReplaceOk = false;
        String appNameTmp = appName == null ? "" : appName;
        this.removeAggrConfigInfo(dataId, group, tenant);
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "datum_id", "app_name", "content", "gmt_modified"));
        for (Map.Entry<String, String> datumEntry : datumMap.entrySet()) {
            Object[] args = new Object[]{dataId, group, tenantTmp, datumEntry.getKey(), appNameTmp, datumEntry.getValue(), new Timestamp(System.currentTimeMillis())};
            EmbeddedStorageContextUtils.addSqlContext(sql, args);
        }
        try {
            isReplaceOk = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (isReplaceOk == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = isReplaceOk;
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSingleAggrConfigInfo(String dataId, String group, String tenant, String datumId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id", "datum_id"));
        Object[] args = new Object[]{dataId, group, tenantTmp, datumId};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("[aggregation with single] Configuration deletion failed");
            }
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAggrConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id"));
        Object[] args = new Object[]{dataId, group, tenantTmp};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("[aggregation with all] Configuration deletion failed");
            }
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean batchRemoveAggr(String dataId, String group, String tenant, List<String> datumList) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        StringBuilder datumString = new StringBuilder();
        for (String datum : datumList) {
            datumString.append('\'').append(datum).append("',");
        }
        datumString.deleteCharAt(datumString.length() - 1);
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.batchRemoveAggr(datumList);
        Object[] args = new Object[]{dataId, group, tenantTmp};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("[aggregation] Failed to configure batch deletion");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public int aggrConfigInfoCount(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.count(Arrays.asList("data_id", "group_id", "tenant_id"));
        Integer result = this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp}, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    @Override
    public int aggrConfigInfoCount(String dataId, String group, String tenant, List<String> datumIds, boolean isIn) {
        if (datumIds == null || datumIds.isEmpty()) {
            return 0;
        }
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.aggrConfigInfoCount(datumIds.size(), isIn);
        List objectList = CollectionUtils.list((Object[])new Object[]{dataId, group, tenantTmp});
        objectList.addAll(datumIds);
        Integer result = this.databaseOperate.queryOne(sql, objectList.toArray(), Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    @Override
    public ConfigInfoAggr findSingleConfigInfoAggr(String dataId, String group, String tenant, String datumId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "datum_id", "app_name", "content"), Arrays.asList("data_id", "group_id", "tenant_id", "datum_id"));
        return this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp, datumId}, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfoAggr> findConfigInfoAggr(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.findConfigInfoAggrIsOrdered();
        return this.databaseOperate.queryMany(sql, new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoAggr> findConfigInfoAggrByPage(String dataId, String group, String tenant, int pageNo, int pageSize) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        int startRow = (pageNo - 1) * pageSize;
        String sqlCountRows = configInfoAggrMapper.select(Arrays.asList("count(*)"), Arrays.asList("data_id", "group_id", "tenant_id"));
        String sqlFetchRows = configInfoAggrMapper.findConfigInfoAggrByPageFetchRows(startRow, pageSize);
        PaginationHelper<ConfigInfoAggr> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, new Object[]{dataId, group, tenantTmp}, sqlFetchRows, new Object[]{dataId, group, tenantTmp}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoAggr> findConfigInfoAggrLike(int pageNo, int pageSize, ConfigKey[] configKeys, boolean blacklist) {
        String sqlCountRows = "SELECT count(*) FROM config_info_aggr WHERE ";
        String sqlFetchRows = "SELECT data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE ";
        StringBuilder where = new StringBuilder(" 1=1 ");
        if (configKeys.length == 0 && !blacklist) {
            Page<ConfigInfoAggr> page = new Page<ConfigInfoAggr>();
            page.setTotalCount(0);
            return page;
        }
        ArrayList<String> params = new ArrayList<String>();
        boolean isFirst = true;
        for (ConfigKey configInfoAggr : configKeys) {
            boolean isFirstSub;
            String dataId = configInfoAggr.getDataId();
            String group = configInfoAggr.getGroup();
            String appName = configInfoAggr.getAppName();
            if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)appName)) break;
            if (blacklist) {
                if (isFirst) {
                    isFirst = false;
                    where.append(" AND ");
                } else {
                    where.append(" AND ");
                }
                where.append('(');
                isFirstSub = true;
                if (!StringUtils.isBlank((CharSequence)dataId)) {
                    where.append(" data_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(dataId));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)group)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" group_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(group));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)appName)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" app_name != ? ");
                    params.add(appName);
                    isFirstSub = false;
                }
                where.append(") ");
                continue;
            }
            if (isFirst) {
                isFirst = false;
                where.append(" AND ");
            } else {
                where.append(" OR ");
            }
            where.append('(');
            isFirstSub = true;
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" data_id LIKE ? ");
                params.add(this.generateLikeArgument(dataId));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" group_id LIKE ? ");
                params.add(this.generateLikeArgument(group));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" app_name = ? ");
                params.add(appName);
                isFirstSub = false;
            }
            where.append(") ");
        }
        PaginationHelper<ConfigInfoAggr> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCountRows + where.toString(), sqlFetchRows + where.toString(), params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfoChanged> findAllAggrGroup() {
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.findAllAggrGroupByDistinct();
        return this.databaseOperate.queryMany(sql, EMPTY_ARRAY, RowMapperManager.CONFIG_INFO_CHANGED_ROW_MAPPER);
    }

    @Override
    public List<String> findDatumIdByContent(String dataId, String groupId, String content) {
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.select(Collections.singletonList("datum_id"), Arrays.asList("data_id", "group_id", "content"));
        return this.databaseOperate.queryMany(sql, new Object[]{dataId, groupId, content}, String.class);
    }
}

